#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_eb812a30-b5aa-45ec-8ed7-1b5e582c18ab_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-eb812a30-b5aa-45ec-8ed7-1b5e582c18ab.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-eb812a30-b5aa-45ec-8ed7-1b5e582c18ab.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['eb812a30-b5aa-45ec-8ed7-1b5e582c18ab']['InstallationDir']}/service-eb812a30-b5aa-45ec-8ed7-1b5e582c18ab.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-eb812a30-b5aa-45ec-8ed7-1b5e582c18ab.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['eb812a30-b5aa-45ec-8ed7-1b5e582c18ab']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['eb812a30-b5aa-45ec-8ed7-1b5e582c18ab']['InstallationDir']}/service-eb812a30-b5aa-45ec-8ed7-1b5e582c18ab.jar" do
  		source "#{node['CHOReOSData']['serviceData']['eb812a30-b5aa-45ec-8ed7-1b5e582c18ab']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_eb812a30-b5aa-45ec-8ed7-1b5e582c18ab_jar]"
		notifies :start, "service[service_eb812a30-b5aa-45ec-8ed7-1b5e582c18ab_jar]"
	end
end

if node['CHOReOSData']['serviceData']['eb812a30-b5aa-45ec-8ed7-1b5e582c18ab']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['eb812a30-b5aa-45ec-8ed7-1b5e582c18ab']['InstallationDir']}/service-eb812a30-b5aa-45ec-8ed7-1b5e582c18ab.jar" do
		notifies :stop, "service[service_eb812a30-b5aa-45ec-8ed7-1b5e582c18ab_jar]", :immediately
		#notifies :disable, "service[service_eb812a30-b5aa-45ec-8ed7-1b5e582c18ab_jar]", :immediately
		action :delete
	end
end