#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada']['InstallationDir']}/service-ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada']['InstallationDir']}/service-ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada_jar]"
		notifies :start, "service[service_ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada']['InstallationDir']}/service-ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada.jar" do
		notifies :stop, "service[service_ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada_jar]", :immediately
		#notifies :disable, "service[service_ec4e2d0b-7350-4ef0-8b09-deeb8b2e1ada_jar]", :immediately
		action :delete
	end
end