#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ed2664e5-d450-4ba2-862d-7b3e66a130c9_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ed2664e5-d450-4ba2-862d-7b3e66a130c9.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ed2664e5-d450-4ba2-862d-7b3e66a130c9.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ed2664e5-d450-4ba2-862d-7b3e66a130c9']['InstallationDir']}/service-ed2664e5-d450-4ba2-862d-7b3e66a130c9.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ed2664e5-d450-4ba2-862d-7b3e66a130c9.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ed2664e5-d450-4ba2-862d-7b3e66a130c9']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ed2664e5-d450-4ba2-862d-7b3e66a130c9']['InstallationDir']}/service-ed2664e5-d450-4ba2-862d-7b3e66a130c9.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ed2664e5-d450-4ba2-862d-7b3e66a130c9']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ed2664e5-d450-4ba2-862d-7b3e66a130c9_jar]"
		notifies :start, "service[service_ed2664e5-d450-4ba2-862d-7b3e66a130c9_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ed2664e5-d450-4ba2-862d-7b3e66a130c9']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ed2664e5-d450-4ba2-862d-7b3e66a130c9']['InstallationDir']}/service-ed2664e5-d450-4ba2-862d-7b3e66a130c9.jar" do
		notifies :stop, "service[service_ed2664e5-d450-4ba2-862d-7b3e66a130c9_jar]", :immediately
		#notifies :disable, "service[service_ed2664e5-d450-4ba2-862d-7b3e66a130c9_jar]", :immediately
		action :delete
	end
end