#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ee3e1689-6502-43f5-b026-bb08f8a0a82a_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceee3e1689-6502-43f5-b026-bb08f8a0a82aDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['ee3e1689-6502-43f5-b026-bb08f8a0a82a']['installationDir']}/serviceee3e1689-6502-43f5-b026-bb08f8a0a82aDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceee3e1689-6502-43f5-b026-bb08f8a0a82aDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ee3e1689-6502-43f5-b026-bb08f8a0a82a']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ee3e1689-6502-43f5-b026-bb08f8a0a82a']['InstallationDir']}/serviceee3e1689-6502-43f5-b026-bb08f8a0a82aDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ee3e1689-6502-43f5-b026-bb08f8a0a82a']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ee3e1689-6502-43f5-b026-bb08f8a0a82a_jar]"
		notifies :start, "service[service_ee3e1689-6502-43f5-b026-bb08f8a0a82a_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ee3e1689-6502-43f5-b026-bb08f8a0a82a']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ee3e1689-6502-43f5-b026-bb08f8a0a82a']['InstallationDir']}/serviceee3e1689-6502-43f5-b026-bb08f8a0a82aDeploy.jar" do
		notifies :stop, "service[service_ee3e1689-6502-43f5-b026-bb08f8a0a82a_jar]", :immediately
		#notifies :disable, "service[service_ee3e1689-6502-43f5-b026-bb08f8a0a82a_jar]", :immediately
		action :delete
	end
end