#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_efd924ba-a676-4d63-afd7-acaf7b9dd2a2_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-efd924ba-a676-4d63-afd7-acaf7b9dd2a2.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-efd924ba-a676-4d63-afd7-acaf7b9dd2a2.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['efd924ba-a676-4d63-afd7-acaf7b9dd2a2']['InstallationDir']}/service-efd924ba-a676-4d63-afd7-acaf7b9dd2a2.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-efd924ba-a676-4d63-afd7-acaf7b9dd2a2.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['efd924ba-a676-4d63-afd7-acaf7b9dd2a2']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['efd924ba-a676-4d63-afd7-acaf7b9dd2a2']['InstallationDir']}/service-efd924ba-a676-4d63-afd7-acaf7b9dd2a2.jar" do
  		source "#{node['CHOReOSData']['serviceData']['efd924ba-a676-4d63-afd7-acaf7b9dd2a2']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_efd924ba-a676-4d63-afd7-acaf7b9dd2a2_jar]"
		notifies :start, "service[service_efd924ba-a676-4d63-afd7-acaf7b9dd2a2_jar]"
	end
end

if node['CHOReOSData']['serviceData']['efd924ba-a676-4d63-afd7-acaf7b9dd2a2']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['efd924ba-a676-4d63-afd7-acaf7b9dd2a2']['InstallationDir']}/service-efd924ba-a676-4d63-afd7-acaf7b9dd2a2.jar" do
		notifies :stop, "service[service_efd924ba-a676-4d63-afd7-acaf7b9dd2a2_jar]", :immediately
		#notifies :disable, "service[service_efd924ba-a676-4d63-afd7-acaf7b9dd2a2_jar]", :immediately
		action :delete
	end
end