#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_f0b28f99-3b40-44c4-97b3-55ef24ea7d20_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-f0b28f99-3b40-44c4-97b3-55ef24ea7d20.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-f0b28f99-3b40-44c4-97b3-55ef24ea7d20.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['f0b28f99-3b40-44c4-97b3-55ef24ea7d20']['InstallationDir']}/service-f0b28f99-3b40-44c4-97b3-55ef24ea7d20.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-f0b28f99-3b40-44c4-97b3-55ef24ea7d20.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['f0b28f99-3b40-44c4-97b3-55ef24ea7d20']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['f0b28f99-3b40-44c4-97b3-55ef24ea7d20']['InstallationDir']}/service-f0b28f99-3b40-44c4-97b3-55ef24ea7d20.jar" do
  		source "#{node['CHOReOSData']['serviceData']['f0b28f99-3b40-44c4-97b3-55ef24ea7d20']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_f0b28f99-3b40-44c4-97b3-55ef24ea7d20_jar]"
		notifies :start, "service[service_f0b28f99-3b40-44c4-97b3-55ef24ea7d20_jar]"
	end
end

if node['CHOReOSData']['serviceData']['f0b28f99-3b40-44c4-97b3-55ef24ea7d20']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['f0b28f99-3b40-44c4-97b3-55ef24ea7d20']['InstallationDir']}/service-f0b28f99-3b40-44c4-97b3-55ef24ea7d20.jar" do
		notifies :stop, "service[service_f0b28f99-3b40-44c4-97b3-55ef24ea7d20_jar]", :immediately
		#notifies :disable, "service[service_f0b28f99-3b40-44c4-97b3-55ef24ea7d20_jar]", :immediately
		action :delete
	end
end