#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_f70e9722-b2f7-4f27-9fb7-715a1a4e2c40_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-f70e9722-b2f7-4f27-9fb7-715a1a4e2c40.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-f70e9722-b2f7-4f27-9fb7-715a1a4e2c40.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['f70e9722-b2f7-4f27-9fb7-715a1a4e2c40']['InstallationDir']}/service-f70e9722-b2f7-4f27-9fb7-715a1a4e2c40.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-f70e9722-b2f7-4f27-9fb7-715a1a4e2c40.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['f70e9722-b2f7-4f27-9fb7-715a1a4e2c40']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['f70e9722-b2f7-4f27-9fb7-715a1a4e2c40']['InstallationDir']}/service-f70e9722-b2f7-4f27-9fb7-715a1a4e2c40.jar" do
  		source "#{node['CHOReOSData']['serviceData']['f70e9722-b2f7-4f27-9fb7-715a1a4e2c40']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_f70e9722-b2f7-4f27-9fb7-715a1a4e2c40_jar]"
		notifies :start, "service[service_f70e9722-b2f7-4f27-9fb7-715a1a4e2c40_jar]"
	end
end

if node['CHOReOSData']['serviceData']['f70e9722-b2f7-4f27-9fb7-715a1a4e2c40']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['f70e9722-b2f7-4f27-9fb7-715a1a4e2c40']['InstallationDir']}/service-f70e9722-b2f7-4f27-9fb7-715a1a4e2c40.jar" do
		notifies :stop, "service[service_f70e9722-b2f7-4f27-9fb7-715a1a4e2c40_jar]", :immediately
		#notifies :disable, "service[service_f70e9722-b2f7-4f27-9fb7-715a1a4e2c40_jar]", :immediately
		action :delete
	end
end