#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_f857d396-b174-48c7-9a7a-fe66bb26a172_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/servicef857d396-b174-48c7-9a7a-fe66bb26a172Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['f857d396-b174-48c7-9a7a-fe66bb26a172']['installationDir']}/servicef857d396-b174-48c7-9a7a-fe66bb26a172Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/servicef857d396-b174-48c7-9a7a-fe66bb26a172Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['f857d396-b174-48c7-9a7a-fe66bb26a172']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['f857d396-b174-48c7-9a7a-fe66bb26a172']['InstallationDir']}/servicef857d396-b174-48c7-9a7a-fe66bb26a172Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['f857d396-b174-48c7-9a7a-fe66bb26a172']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_f857d396-b174-48c7-9a7a-fe66bb26a172_jar]"
		notifies :start, "service[service_f857d396-b174-48c7-9a7a-fe66bb26a172_jar]"
	end
end

if node['CHOReOSData']['serviceData']['f857d396-b174-48c7-9a7a-fe66bb26a172']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['f857d396-b174-48c7-9a7a-fe66bb26a172']['InstallationDir']}/servicef857d396-b174-48c7-9a7a-fe66bb26a172Deploy.jar" do
		notifies :stop, "service[service_f857d396-b174-48c7-9a7a-fe66bb26a172_jar]", :immediately
		#notifies :disable, "service[service_f857d396-b174-48c7-9a7a-fe66bb26a172_jar]", :immediately
		action :delete
	end
end