#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ffc768b7-28d3-4db8-8513-7c4a99bb7032_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ffc768b7-28d3-4db8-8513-7c4a99bb7032.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ffc768b7-28d3-4db8-8513-7c4a99bb7032.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ffc768b7-28d3-4db8-8513-7c4a99bb7032']['InstallationDir']}/service-ffc768b7-28d3-4db8-8513-7c4a99bb7032.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ffc768b7-28d3-4db8-8513-7c4a99bb7032.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ffc768b7-28d3-4db8-8513-7c4a99bb7032']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ffc768b7-28d3-4db8-8513-7c4a99bb7032']['InstallationDir']}/service-ffc768b7-28d3-4db8-8513-7c4a99bb7032.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ffc768b7-28d3-4db8-8513-7c4a99bb7032']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ffc768b7-28d3-4db8-8513-7c4a99bb7032_jar]"
		notifies :start, "service[service_ffc768b7-28d3-4db8-8513-7c4a99bb7032_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ffc768b7-28d3-4db8-8513-7c4a99bb7032']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ffc768b7-28d3-4db8-8513-7c4a99bb7032']['InstallationDir']}/service-ffc768b7-28d3-4db8-8513-7c4a99bb7032.jar" do
		notifies :stop, "service[service_ffc768b7-28d3-4db8-8513-7c4a99bb7032_jar]", :immediately
		#notifies :disable, "service[service_ffc768b7-28d3-4db8-8513-7c4a99bb7032_jar]", :immediately
		action :delete
	end
end