/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.client;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.ow2.choreos.chors.ChoreographyDeployer;
import org.ow2.choreos.chors.ChoreographyNotFoundException;
import org.ow2.choreos.chors.EnactmentException;
import org.ow2.choreos.chors.datamodel.Choreography;
import org.ow2.choreos.chors.datamodel.ChoreographySpec;

public class ChorDeployerClient
implements ChoreographyDeployer {
    private String host;
    private Pattern pattern = Pattern.compile(".*/(.*)$");

    public ChorDeployerClient(String host) {
        this.host = host;
    }

    private WebClient setupClient() {
        WebClient client = WebClient.create((String)this.host);
        HTTPConduit http = (HTTPConduit)WebClient.getConfig((Object)client).getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(0L);
        httpClientPolicy.setReceiveTimeout(0L);
        http.setClient(httpClientPolicy);
        return client;
    }

    private String getId(Response response) {
        String location = (String)((List)response.getMetadata().get((Object)"location")).get(0);
        Matcher matcher = this.pattern.matcher(location);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String createChoreography(ChoreographySpec chor) {
        String chorId;
        WebClient client = this.setupClient();
        client.path((Object)"chors");
        try {
            Response response = client.post((Object)chor);
            chorId = this.getId(response);
        }
        catch (WebApplicationException e) {
            return null;
        }
        return chorId;
    }

    @Override
    public Choreography getChoreography(String chorId) throws ChoreographyNotFoundException {
        Choreography chor;
        WebClient client = this.setupClient();
        client.path((Object)"chors");
        client.path((Object)chorId);
        try {
            chor = (Choreography)client.get(Choreography.class);
        }
        catch (WebApplicationException e) {
            throw new ChoreographyNotFoundException(chorId);
        }
        return chor;
    }

    @Override
    public Choreography enactChoreography(String chorId) throws EnactmentException, ChoreographyNotFoundException {
        Choreography chor;
        WebClient client = this.setupClient();
        client.path((Object)"chors");
        client.path((Object)chorId);
        client.path((Object)"enactment");
        try {
            chor = (Choreography)client.post(null, Choreography.class);
        }
        catch (WebApplicationException e) {
            int code = e.getResponse().getStatus();
            if (code == 400 || code == 404) {
                throw new ChoreographyNotFoundException(chorId);
            }
            throw new EnactmentException("POST /chors/" + chorId + "/enactment has failed (Error " + code + ")");
        }
        System.out.println("At Client: " + chor);
        return chor;
    }

    @Override
    public void updateChoreography(String chorId, ChoreographySpec spec) throws ChoreographyNotFoundException, EnactmentException {
        WebClient client = this.setupClient();
        client.path((Object)"chors");
        client.path((Object)chorId);
        client.path((Object)"update");
        try {
            client.put((Object)spec);
        }
        catch (WebApplicationException e) {
            int code = e.getResponse().getStatus();
            if (code == 400 || code == 404) {
                throw new ChoreographyNotFoundException(chorId);
            }
            throw new EnactmentException("PUT /chors/" + chorId + "/update has failed (Error " + code + ")");
        }
    }
}

