/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.nodes.client;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.NotImplementedException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.ow2.choreos.nodes.ConfigNotAppliedException;
import org.ow2.choreos.nodes.NodeNotCreatedException;
import org.ow2.choreos.nodes.NodeNotDestroyed;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.NodeNotUpgradedException;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.datamodel.Config;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.nodes.datamodel.NodeCreationRequestSpec;
import org.ow2.choreos.nodes.datamodel.NodeRestRepresentation;
import org.ow2.choreos.services.datamodel.ResourceImpact;

public class NodesClient
implements NodePoolManager {
    private String host;

    public NodesClient(String host) {
        this.host = host;
    }

    private WebClient setupClient() {
        WebClient client = WebClient.create((String)this.host);
        HTTPConduit http = (HTTPConduit)WebClient.getConfig((Object)client).getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(0L);
        httpClientPolicy.setReceiveTimeout(0L);
        http.setClient(httpClientPolicy);
        return client;
    }

    @Override
    public Node createNode(Node node, ResourceImpact resourceImpact) throws NodeNotCreatedException {
        WebClient client = this.setupClient();
        client.path((Object)"nodes");
        client.type("application/xml");
        NodeCreationRequestSpec request = new NodeCreationRequestSpec(node, resourceImpact);
        NodeRestRepresentation nodeRest = null;
        try {
            nodeRest = (NodeRestRepresentation)client.post((Object)request, NodeRestRepresentation.class);
        }
        catch (WebApplicationException e) {
            throw new NodeNotCreatedException(node.getId());
        }
        return new Node(nodeRest);
    }

    @Override
    public List<Node> getNodes() {
        throw new NotImplementedException();
    }

    @Override
    public Node getNode(String nodeId) throws NodeNotFoundException {
        WebClient client = this.setupClient();
        client.path((Object)("nodes/" + nodeId));
        NodeRestRepresentation nodeRest = null;
        try {
            nodeRest = (NodeRestRepresentation)client.get(NodeRestRepresentation.class);
        }
        catch (WebApplicationException e) {
            throw new NodeNotFoundException(nodeId);
        }
        return new Node(nodeRest);
    }

    @Override
    public void destroyNode(String nodeId) throws NodeNotDestroyed, NodeNotFoundException {
        throw new NotImplementedException();
    }

    @Override
    public void upgradeNode(String nodeId) throws NodeNotUpgradedException {
        WebClient client = this.setupClient();
        client.path((Object)"nodes");
        client.path((Object)nodeId);
        client.path((Object)"upgrade");
        Response response = client.post(null);
        if (response.getStatus() != 200) {
            throw new NodeNotUpgradedException(nodeId);
        }
    }

    @Override
    public List<Node> applyConfig(Config config) throws ConfigNotAppliedException {
        WebClient client = this.setupClient();
        client.path((Object)"nodes/configs");
        NodeRestRepresentation nodeRest = null;
        try {
            nodeRest = (NodeRestRepresentation)client.post((Object)config, NodeRestRepresentation.class);
        }
        catch (WebApplicationException e) {
            throw new ConfigNotAppliedException(config.getName());
        }
        ArrayList<Node> resultList = new ArrayList<Node>();
        resultList.add(new Node(nodeRest));
        return resultList;
    }

    @Override
    public void destroyNodes() throws NodeNotDestroyed {
        throw new NotImplementedException();
    }
}

