/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.nodes.datamodel;

import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.datamodel.ResourceImpact;
import org.ow2.choreos.services.datamodel.ResourceImpactDefs;

@XmlRootElement
public class NodeCreationRequestSpec {
    private String nodeId;
    private Integer nodeCpus;
    private Integer nodeRam;
    private Integer nodeStorage;
    private String nodeSo;
    private String nodeZone;
    private String nodeIp;
    private String nodeHostname;
    private String nodeImage;
    private Integer nodeState;
    private ResourceImpactDefs.MemoryTypes memoryImpact;
    private String cpuImpact;
    private String ioImpact;
    private String regionImpact;

    public NodeCreationRequestSpec() {
    }

    public NodeCreationRequestSpec(Node node, ResourceImpact resImpact) {
        this.nodeId = node.getId();
        this.nodeCpus = node.getCpus();
        this.nodeRam = node.getRam();
        this.nodeStorage = node.getStorage();
        this.nodeSo = node.getSo();
        this.nodeZone = node.getZone();
        this.nodeIp = node.getIp();
        this.nodeHostname = node.getHostname();
        this.nodeImage = node.getImage();
        this.nodeState = node.getState();
        this.memoryImpact = resImpact.getMemory();
        this.cpuImpact = resImpact.getCpu();
        this.ioImpact = resImpact.getIo();
        this.regionImpact = resImpact.getRegion();
    }

    public Node getNode() {
        Node node = new Node();
        node.setId(this.nodeId);
        node.setCpus(this.nodeCpus);
        node.setRam(this.nodeRam);
        node.setStorage(this.nodeStorage);
        node.setSo(this.nodeSo);
        node.setZone(this.nodeZone);
        node.setIp(this.nodeIp);
        node.setHostname(this.nodeHostname);
        node.setImage(this.nodeImage);
        node.setState(this.nodeState);
        return node;
    }

    public ResourceImpact getResourceImpact() {
        ResourceImpact impact = new ResourceImpact();
        impact.setCpu(this.cpuImpact);
        impact.setIo(this.ioImpact);
        impact.setMemory(this.memoryImpact);
        impact.setRegion(this.regionImpact);
        return impact;
    }
}

