/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.services.datamodel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIInfoRetriever {
    private static final Pattern URI_REGEX = Pattern.compile("^(http://)?(.*?)(:\\d+)?/.*$");
    private static final Pattern IP_REGEX = Pattern.compile("^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$");
    private String uri;

    public URIInfoRetriever(String uri) {
        this.uri = uri;
    }

    private String getHostnameOrIp() {
        Matcher matcher = URI_REGEX.matcher(this.uri);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    private boolean isIp(String ip) {
        Matcher matcher = IP_REGEX.matcher(ip);
        return matcher.matches();
    }

    public String getHostname() {
        String hostname = this.getHostnameOrIp();
        if (!this.isIp(hostname)) {
            return hostname;
        }
        return null;
    }

    public String getIp() {
        String ip = this.getHostnameOrIp();
        if (this.isIp(ip)) {
            return ip;
        }
        return null;
    }
}

