/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chef;

import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.ow2.choreos.utils.SshCommandFailed;
import org.ow2.choreos.utils.SshUtil;

public class ChefNodeNameRetriever {
    private static final String CHEF_NAME_SCRIPT = "chef/my_chef_name.sh";
    private Logger logger = Logger.getLogger(ChefNodeNameRetriever.class);

    private String getScript() {
        URL scriptFile = ClassLoader.getSystemResource(CHEF_NAME_SCRIPT);
        String command = null;
        try {
            command = FileUtils.readFileToString((File)new File(scriptFile.getFile()));
        }
        catch (IOException e) {
            this.logger.error((Object)"Should not happen!", (Throwable)e);
        }
        return command;
    }

    public String getChefNodeName(String host, String user, String pKeyPath) throws JSchException, SshCommandFailed {
        SshUtil ssh = new SshUtil(host, user, pKeyPath);
        String script = this.getScript();
        String chefNodeName = ssh.runCommand(script, true);
        if (chefNodeName == null || chefNodeName.isEmpty()) {
            chefNodeName = this.getHostname(ssh);
        }
        chefNodeName = chefNodeName.replace("\n", "").trim();
        return chefNodeName;
    }

    private String getHostname(SshUtil ssh) throws JSchException, SshCommandFailed {
        return ssh.runCommand("hostname");
    }

    public String retrieveChefNodeNameFromBootstrapLog(String bootstrapLog) {
        Pattern pattern = Pattern.compile("Creating a new client identity for (.*) using the validator key");
        Matcher matcher = pattern.matcher(bootstrapLog);
        if (matcher.find()) {
            String chefNodeName = matcher.group(1);
            return chefNodeName;
        }
        throw new IllegalArgumentException("Could not extract chef node name from bootstrap log.");
    }
}

