/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.OutputStream;
import org.apache.geronimo.mail.util.StringBufferOutputStream;
import org.apache.log4j.Logger;
import org.ow2.choreos.utils.SshCommandFailed;

public class SshUtil {
    private Logger logger = Logger.getLogger(SshUtil.class);
    private static final int CONNECTION_TIMEOUT = 5000;
    private final String hostname;
    private final String user;
    private final String privateKeyFile;
    private Session session;

    public SshUtil(String hostname, String user, String privateKeyFile) {
        this.hostname = hostname;
        this.user = user;
        this.privateKeyFile = privateKeyFile;
    }

    private Session getSession() throws JSchException {
        if (this.session != null && this.session.isConnected()) {
            return this.session;
        }
        JSch jsch = new JSch();
        jsch.addIdentity(this.privateKeyFile);
        this.session = jsch.getSession(this.user, this.hostname);
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.setConfig("UserKnownHostsFile", "/dev/null");
        return this.session;
    }

    public boolean isAccessible() {
        Session session = null;
        try {
            session = this.getSession();
            session.connect(5000);
        }
        catch (JSchException e) {
            return false;
        }
        this.session = session;
        return this.session.isConnected();
    }

    public String runCommand(String command) throws JSchException, SshCommandFailed {
        return this.runCommand(command, false);
    }

    public String runCommand(String command, boolean retry) throws JSchException, SshCommandFailed {
        int SLEEPING_TIME = 5000;
        String output = null;
        try {
            output = this.runCommandOnce(command);
        }
        catch (JSchException e) {
            if (retry) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                return this.runCommand(command, retry);
            }
            throw e;
        }
        return output;
    }

    public String runCommandOnce(String command) throws JSchException, SshCommandFailed {
        String output = null;
        Session session = this.getSession();
        try {
            session.connect(5000);
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            StringBuffer sb = new StringBuffer();
            channel.setOutputStream((OutputStream)new StringBufferOutputStream(sb));
            channel.connect();
            while (!channel.isClosed()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.logger.error((Object)"Sleep exception \"u.u", (Throwable)e);
                }
            }
            if (channel.getExitStatus() > 0) {
                throw new SshCommandFailed(command);
            }
            channel.disconnect();
            session.disconnect();
            output = sb.toString();
        }
        catch (JSchException e) {
            this.logger.debug((Object)("Could not connect to " + this.user + "@" + this.hostname + " with key " + this.privateKeyFile));
            throw e;
        }
        return output;
    }

    public void disconnect() {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

