/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.airline;

import java.io.IOException;
import org.choreos.services.backends.airline.AirTrafficEventingResolverCallback;
import org.choreos.services.backends.airline.DummyAirTrafficEventingConsumer;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.HTTPBinding;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.PlatformIPNetworkDetection;
import org.ws4d.java.service.DefaultDevice;
import org.ws4d.java.service.DefaultService;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.URI;

public class AirTrafficEventingClientResolver
extends DefaultService {
    public static final String NAMESPACE = "http://services.choreos.org/backends/AirTrafficEventingClient/";
    public static final int port = 12320;
    public static final String NAME_SERVICE = "AirTrafficEventingClientResolver";
    protected DefaultDevice device;
    protected DummyAirTrafficEventingConsumer consumer;

    public AirTrafficEventingClientResolver(DummyAirTrafficEventingConsumer consumer) throws IOException {
        super(-1);
        this.setServiceId(new URI(NAMESPACE, "/" + NAME_SERVICE));
        this.device = new DefaultDevice(-1);
        this.setServiceId(new URI(NAMESPACE, "/AirTrafficEventingClientResolver"));
        this.defineService(consumer);
        this.device.addService((LocalService)this);
        Iterator it = PlatformIPNetworkDetection.getInstance().getAddresses();
        while (it.hasNext()) {
            HashMap.Entry ip = (HashMap.Entry)it.next();
            IPAddress current = (IPAddress)ip.getValue();
            if (current.isIPv6()) continue;
            HTTPBinding serviceBinding = new HTTPBinding(current, 12320, NAME_SERVICE);
            this.addBinding((CommunicationBinding)serviceBinding);
            HTTPBinding deviceBinding = new HTTPBinding(current, 12320, "AirTrafficEventingResolverDevice");
            this.device.addBinding((CommunicationBinding)deviceBinding);
        }
    }

    protected void defineService(DummyAirTrafficEventingConsumer consumer) throws IOException {
        this.addOperation(new AirTrafficEventingResolverCallback(consumer));
    }

    public void startAirTrafficEventingResolver() throws IOException {
        this.device.start();
    }

    public void stopAirTrafficEventingResolver() throws IOException {
        this.device.stop();
    }

    public DummyAirTrafficEventingConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DummyAirTrafficEventingConsumer consumer) {
        this.consumer = consumer;
    }
}

