/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.airline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.choreos.services.backends.airline.AirTrafficEventing;
import org.choreos.services.backends.airline.AirTrafficEventingClientResolver;
import org.choreos.services.backends.airline.AirTrafficEventingConsumer;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.client.DefaultClient;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.service.InvocationException;
import org.ws4d.java.service.Operation;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.ParameterUtil;

public class DummyAirTrafficEventingConsumer
implements MessageListener,
Runnable,
AirTrafficEventingConsumer {
    Logger logger = Logger.getLogger(AirTrafficEventing.class.getName());
    protected QueueConnection connection;
    protected MessageConsumer consumer;
    protected String eprAirTrafficEventingClient;
    protected AirTrafficEventingClientResolver resolver;
    protected boolean withBroker;

    public DummyAirTrafficEventingConsumer(boolean withBroker) throws IOException {
        DPWSFramework.start((String[])new String[0]);
        Log.setLogLevel((int)3);
        this.resolver = new AirTrafficEventingClientResolver(this);
        this.withBroker = withBroker;
    }

    @Override
    public boolean hasBroker() {
        return this.withBroker;
    }

    @Override
    public void startConsumer() throws IOException {
        this.resolver.startAirTrafficEventingResolver();
        if (this.withBroker) {
            try {
                InitialContext context = new InitialContext();
                QueueConnectionFactory factory = (QueueConnectionFactory)context.lookup("qcf");
                this.connection = factory.createQueueConnection();
                QueueSession session = this.connection.createQueueSession(false, 1);
                Queue queue = (Queue)context.lookup("airTrafficEventing");
                context.close();
                this.connection.start();
                this.consumer = session.createConsumer((Destination)queue);
                this.consumer.setMessageListener((MessageListener)this);
                this.logger.info("consumer ready");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public AirTrafficEventingClientResolver getResolver() {
        return this.resolver;
    }

    public void stopConsumer() throws IOException {
        try {
            if (this.withBroker) {
                this.connection.close();
            }
            this.resolver.stopAirTrafficEventingResolver();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void onMessage(Message arg0) {
        MapMessage message = (MapMessage)arg0;
        try {
            String flightNumber = message.getString("flightNumber");
            String passengers = message.getString("passengers");
            this.invokeDPWS(flightNumber, passengers);
        }
        catch (JMSException e) {
            this.logger.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            this.logger.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationException e) {
            this.logger.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    public void invokeDPWS(String flightNumber, String passengers) throws TimeoutException, InvocationException {
        System.out.println("Send a warning for an unexpected arrival to the DPWS Air Traffic Eventing client");
        EndpointReference epr = new EndpointReference(new URI(this.eprAirTrafficEventingClient));
        DefaultClient client = new DefaultClient();
        ServiceReference servRef = client.getServiceReference(epr, "DPWS");
        Service serviceProxy = servRef.getService();
        Operation op = serviceProxy.getAnyOperation(new QName("AirTrafficEventingClientPT", "http://services.choreos.org/backends/AirTrafficEventingClient/"), "WarnReroute");
        ParameterValue input = op.createInputValue();
        ParameterUtil.setString((ParameterValue)input, (String)"flightNumber", (String)flightNumber);
        ParameterUtil.setString((ParameterValue)input, (String)"passengers", (String)passengers);
        op.invoke(input);
    }

    public String getEprAirTrafficEventingClient() {
        return this.eprAirTrafficEventingClient;
    }

    public void setEprAirTrafficEventingClient(String eprAirTrafficEventingClient) {
        this.eprAirTrafficEventingClient = eprAirTrafficEventingClient;
    }

    @Override
    public void run() {
        try {
            this.stopConsumer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            DummyAirTrafficEventingConsumer dummyApp = new DummyAirTrafficEventingConsumer(true);
            Thread hook = new Thread(dummyApp);
            Runtime.getRuntime().addShutdownHook(hook);
            dummyApp.startConsumer();
            System.out.println("Press any key to quit");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            reader.readLine();
            dummyApp.stopConsumer();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

