/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.hotel;

import java.rmi.RemoteException;
import net.jini.core.entry.Entry;
import net.jini.core.transaction.TransactionException;
import net.jini.space.JavaSpace05;
import org.choreos.services.backends.hotel.JavaspaceFinder;
import org.choreos.services.backends.hotel.RoomState;
import org.ws4d.java.service.InvocationException;
import org.ws4d.java.service.InvokeDelegate;
import org.ws4d.java.service.Operation;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.util.ParameterUtil;

public class BookingOrderDelegate
implements InvokeDelegate {
    protected JavaSpace05 roomPool;

    public BookingOrderDelegate(String urlRoomPool) throws Exception {
        if (urlRoomPool != null) {
            JavaspaceFinder finder = new JavaspaceFinder();
            this.roomPool = finder.searchJavaspace(urlRoomPool);
            if (this.roomPool == null) {
                throw new NullPointerException("The Room pool javaspace is not found");
            }
        } else {
            System.out.println("Dummy Room Pool client without Javaspace");
        }
    }

    public ParameterValue invoke(Operation operation, ParameterValue arguments) throws InvocationException {
        Integer room = new Integer(ParameterUtil.getString((ParameterValue)arguments, (String)"room"));
        this.performReservation(room);
        return null;
    }

    public void performReservation(Integer room) {
        System.out.println("perform reservation on room " + room);
        if (this.roomPool != null) {
            RoomState state = new RoomState();
            state.setNumRoom(room);
            state.setReserved(true);
            try {
                this.roomPool.write((Entry)state, null, Long.MAX_VALUE);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
        }
    }
}

