/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.choreos.services.DemoParticipant;
import org.choreos.services.client.airlinegroundstaffmid.AirlineGroundStaffMIDService;
import org.choreos.services.client.airlinegroundstaffmid.AvailableAmenity;
import org.choreos.services.client.airlinegroundstaffmid.ScenarioException_Exception;
import org.choreos.services.data.AmenityType;
import org.choreos.services.data.Flight;
import org.choreos.services.data.InfoForPassenger;
import org.choreos.services.exceptions.ScenarioException;
import org.choreos.services.interfaces.GetInfo;
import org.choreos.services.interfaces.RequestAmenities;
import org.choreos.services.interfaces.SendRerouteWarning;

@WebService
public class Airline
extends DemoParticipant
implements GetInfo,
RequestAmenities,
SendRerouteWarning {
    @Override
    public InfoForPassenger get(@WebParam(name="flight") Flight flight) throws ScenarioException {
        InfoForPassenger result = null;
        System.out.println(this.id + ".get() called");
        return result;
    }

    @Override
    public String request(@WebParam(name="amenities") List<AmenityType> amenities) throws ScenarioException {
        String result = null;
        System.out.println(this.id + ".request() called");
        RequestThread t = new RequestThread(1000L);
        t.start();
        return result;
    }

    @Override
    public void warnReroute(@WebParam(name="flightNumber") String flightNumber, @WebParam(name="passengers") List<String> passengers) throws ScenarioException {
        System.out.println(this.id + ".warnReroute() called");
        WarnThread t = new WarnThread(2000L, flightNumber, passengers);
        t.start();
    }

    public class RequestThread
    extends Thread {
        private long beginSleep;

        public RequestThread(long beginSleep) {
            this.beginSleep = beginSleep;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.beginSleep);
                AirlineGroundStaffMIDService ground = new AirlineGroundStaffMIDService(new URL((String)Airline.this.invocationAddresses.get("airlinegroundstaffmid") + "?wsdl"));
                AvailableAmenity aa = new AvailableAmenity();
                aa.setAmenity(null);
                ground.getAirlineGroundStaffMIDPort().putAmenity(aa);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
            catch (ScenarioException_Exception e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    public class WarnThread
    extends Thread {
        private long beginSleep;
        private String flightNumber;
        private List<String> passengers;

        public WarnThread(long beginSleep, String flightNumber, List<String> passengers) {
            this.beginSleep = beginSleep;
            this.flightNumber = flightNumber;
            this.passengers = passengers;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.beginSleep);
                System.out.println("#####   " + (String)Airline.this.invocationAddresses.get("airlinegroundstaffmid"));
                AirlineGroundStaffMIDService ground = new AirlineGroundStaffMIDService(new URL((String)Airline.this.invocationAddresses.get("airlinegroundstaffmid") + "?wsdl"));
                ground.getAirlineGroundStaffMIDPort().warnArrival(this.flightNumber, this.passengers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

