/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.airline;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.choreos.services.exceptions.ScenarioException;
import org.choreos.services.interfaces.WarnUnexpectedArrival;

public class AirTrafficEventing
implements WarnUnexpectedArrival {
    Logger logger = Logger.getLogger(AirTrafficEventing.class.getName());

    @Override
    public void warnArrival(String flightNumber, List<String> passengers) throws ScenarioException {
        this.logger.log(Level.INFO, "Warn unexpected arrival");
        try {
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", "fr.dyade.aaa.jndi2.client.NamingContextFactory");
            props.setProperty("java.naming.provider.url", "scn://127.0.0.1:16401");
            InitialContext context = new InitialContext(props);
            QueueConnectionFactory factory = (QueueConnectionFactory)context.lookup("qcf");
            QueueConnection connection = factory.createQueueConnection();
            QueueSession session = connection.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup("airTrafficEventing");
            QueueSender sender = session.createSender(queue);
            context.close();
            connection.start();
            MapMessage message = session.createMapMessage();
            message.setString("flightNumber", flightNumber);
            String stringPassengers = StringUtils.join(passengers.iterator(), (String)",");
            message.setString("passengers", stringPassengers);
            sender.send((Message)message);
            connection.close();
            this.logger.info("warn done");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AirTrafficEventing eventing = new AirTrafficEventing();
        String flightNumber = "AF1234";
        ArrayList<String> passengers = new ArrayList<String>();
        passengers.add("passenger1");
        passengers.add("passenger2");
        try {
            eventing.warnArrival(flightNumber, passengers);
        }
        catch (ScenarioException e) {
            e.printStackTrace();
        }
    }
}

