/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.CustomClassLoader;
import com.mathworks.jmi.CustomURLClassLoader;
import com.mathworks.jmi.InternetClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassLoaderManager {
    public static final int VERBOSE_0 = 0;
    public static final int VERBOSE_1 = 1;
    public static final int VERBOSE_2 = 2;
    private static int sCurrentVerboseLevel = 0;
    private static ClassLoaderManager sThis = null;
    private String[] fFileSystemClassPath = null;
    private URL[] fURLClassPath = null;
    private String[] fStringClassPath = null;
    private Vector fNativeLibraryPath = ClassLoaderManager.pathString2Vector(System.getProperty("java.library.path"));
    private CustomClassLoader fCurrentFileSystemClassLoader = null;
    private InternetClassLoader fCurrentInternetClassLoader = null;
    private CustomURLClassLoader fCurrentURLClassLoader = null;
    private boolean fIsEnabled = false;
    private int fDebuggingID = 0;
    private boolean fUseURLClassLoader = true;
    private boolean fDoRecordClassCache = false;

    private ClassLoaderManager() {
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean bl) {
        this.fIsEnabled = bl;
    }

    public ClassLoader getCustomClassLoader() {
        return this.fCurrentFileSystemClassLoader;
    }

    public ClassLoader getCurrentClassLoader() {
        return this.fCurrentURLClassLoader;
    }

    public void addDirToNativeLibraryPath(String string) {
        this.fNativeLibraryPath.add(string);
    }

    public static ClassLoaderManager getClassLoaderManager() {
        if (sThis == null) {
            sThis = new ClassLoaderManager();
            sThis.loadClassPath();
        }
        return sThis;
    }

    public static boolean isReloadable(Class clazz) {
        boolean bl = false;
        ClassLoader classLoader = clazz.getClassLoader();
        if (clazz != null && classLoader != null && (classLoader instanceof CustomURLClassLoader || classLoader instanceof CustomClassLoader || classLoader instanceof InternetClassLoader)) {
            bl = true;
        }
        return bl;
    }

    public static String load() {
        String string = null;
        ClassLoaderManager classLoaderManager = ClassLoaderManager.getClassLoaderManager();
        string = classLoaderManager.loadClassPath();
        return string;
    }

    private String loadClassPath() {
        if (this.fUseURLClassLoader) {
            return this.loadClassPathNew();
        }
        return this.loadClassPathOld();
    }

    private String loadClassPathNew() {
        String string = null;
        if (this.fCurrentURLClassLoader != null) {
            if (this.fCurrentURLClassLoader.isLocked()) {
                string = "One or more java native libraries are loaded. Clearing java not permitted.\nPlease move any packages on the dynamic java path that use:\n" + this.fCurrentFileSystemClassLoader.getLoadedNativeLibrariesString() + "\nonto the static java path";
                return string;
            }
            this.fCurrentURLClassLoader.setValid(false);
            this.fCurrentURLClassLoader = null;
        }
        ++this.fDebuggingID;
        if (this.fURLClassPath != null) {
            if (sCurrentVerboseLevel >= 1) {
                System.out.println("Loading following class path(s) from local file system:");
                for (int i = 0; i < this.fURLClassPath.length; ++i) {
                    System.out.println("* " + this.fURLClassPath[i]);
                }
            }
            this.fCurrentURLClassLoader = new CustomURLClassLoader(this.getClass().getClassLoader(), this.fURLClassPath, this.fNativeLibraryPath, this.fDebuggingID, this.fDoRecordClassCache, sCurrentVerboseLevel);
        }
        return string;
    }

    private String loadClassPathOld() {
        int n;
        String string = null;
        if (this.fCurrentFileSystemClassLoader != null) {
            if (this.fCurrentFileSystemClassLoader.isLocked()) {
                string = "One or more java native libraries are loaded. Clearing java not permitted.\nPlease move any packages on the dynamic java path that use:\n" + this.fCurrentFileSystemClassLoader.getLoadedNativeLibrariesString() + "\nonto the static java path";
                return string;
            }
            this.fCurrentFileSystemClassLoader.setValid(false);
            this.fCurrentFileSystemClassLoader = null;
        }
        ++this.fDebuggingID;
        if (this.fFileSystemClassPath != null) {
            if (sCurrentVerboseLevel >= 1) {
                System.out.println("Loading following class path(s) from local file system:");
                for (n = 0; n < this.fFileSystemClassPath.length; ++n) {
                    System.out.println("* " + this.fFileSystemClassPath[n]);
                }
            }
            this.fCurrentFileSystemClassLoader = new CustomClassLoader(this.getClass().getClassLoader(), this.fFileSystemClassPath, this.fNativeLibraryPath, this.fDebuggingID);
        } else {
            this.fCurrentFileSystemClassLoader = new CustomClassLoader(this.getClass().getClassLoader(), new String[0], this.fNativeLibraryPath, this.fDebuggingID);
        }
        if (this.fURLClassPath != null) {
            if (sCurrentVerboseLevel >= 1) {
                System.out.println("Loading following class path(s) from Internet:");
                for (n = 0; n < this.fURLClassPath.length; ++n) {
                    System.out.println("* " + this.fURLClassPath[n]);
                }
            }
            this.fCurrentInternetClassLoader = new InternetClassLoader(this.fURLClassPath, (ClassLoader)this.fCurrentFileSystemClassLoader, this.fDebuggingID);
        } else {
            this.fCurrentInternetClassLoader = null;
        }
        return string;
    }

    public void setClassPath(String[] stringArray) {
        if (this.fUseURLClassLoader) {
            this.setClassPathNew(stringArray);
        } else {
            this.setClassPathOld(stringArray);
        }
    }

    private URL createURL(String string) {
        URL uRL;
        block4: {
            uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                File file = new File(string);
                try {
                    uRL = file.toURI().toURL();
                }
                catch (Exception exception2) {
                    if (sCurrentVerboseLevel < 1) break block4;
                    System.out.println(exception2);
                }
            }
        }
        return uRL;
    }

    private void setClassPathNew(String[] stringArray) {
        this.fStringClassPath = stringArray;
        if (stringArray != null) {
            this.fURLClassPath = new URL[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.fURLClassPath[i] = this.createURL(stringArray[i]);
            }
        } else {
            this.fURLClassPath = null;
        }
    }

    private void setClassPathOld(String[] stringArray) {
        int n;
        this.fFileSystemClassPath = null;
        this.fURLClassPath = null;
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("http:") || stringArray[n].startsWith("ftp:")) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n3 > 0) {
            this.fFileSystemClassPath = new String[n3];
        }
        if (n2 > 0) {
            this.fURLClassPath = new URL[n2];
        }
        n = 0;
        int n4 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("http:") || stringArray[i].startsWith("ftp:")) {
                try {
                    this.fURLClassPath[n] = new URL(stringArray[i]);
                    ++n;
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println(stringArray[i] + " is not a valid URL");
                    --n;
                }
                continue;
            }
            this.fFileSystemClassPath[n4] = stringArray[i];
            ++n4;
        }
    }

    public String[] getClassPath() {
        if (this.fUseURLClassLoader) {
            return this.getClassPathNew();
        }
        return this.getClassPathOld();
    }

    private String[] getClassPathNew() {
        return this.fStringClassPath;
    }

    private String[] getClassPathOld() {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (this.fFileSystemClassPath != null) {
            n2 = this.fFileSystemClassPath.length;
        }
        if (this.fURLClassPath != null) {
            n3 = this.fURLClassPath.length;
        }
        if (n2 + n3 == 0) {
            return null;
        }
        String[] stringArray = new String[n2 + n3];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.fFileSystemClassPath[n];
        }
        for (n = 0; n < n3; ++n) {
            stringArray[n + n2] = this.fURLClassPath[n].toString();
        }
        return stringArray;
    }

    public static Class findClass(String string) throws ClassNotFoundException {
        ClassLoaderManager classLoaderManager = ClassLoaderManager.getClassLoaderManager();
        if (classLoaderManager != null) {
            Class clazz = classLoaderManager.loadClass(string);
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.fUseURLClassLoader) {
            if (this.fCurrentURLClassLoader != null) {
                return Class.forName(string, true, this.fCurrentURLClassLoader);
            }
            return Class.forName(string);
        }
        return this.loadClassOld(string);
    }

    private Class loadClassOld(String string) throws ClassNotFoundException {
        if (this.fCurrentInternetClassLoader != null) {
            return this.fCurrentInternetClassLoader.loadClass(string);
        }
        if (this.fCurrentFileSystemClassLoader != null) {
            return this.fCurrentFileSystemClassLoader.loadClass(string);
        }
        throw new ClassNotFoundException();
    }

    private static Vector pathString2Vector(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        char c = System.getProperty("path.separator").charAt(0);
        while ((n = string.indexOf(c, n2)) != -1) {
            string2 = string.substring(n2, n).trim();
            if (string2.length() > 0 && string2 != null) {
                vector.addElement(string2);
            }
            n2 = ++n;
        }
        string2 = string.substring(n2).trim();
        if (string2.length() > 0 && string2 != null) {
            vector.addElement(string2);
        }
        return vector;
    }

    public void setVerbose(int n) {
        sCurrentVerboseLevel = n;
        if (this.fUseURLClassLoader && this.fCurrentURLClassLoader != null) {
            this.fCurrentURLClassLoader.setVerbose(n);
        }
    }

    public static int getCurrentVerboseLevel() {
        return sCurrentVerboseLevel;
    }

    public void debugSetDoRecordClassCache(boolean bl) {
        this.fDoRecordClassCache = bl;
        if (this.fUseURLClassLoader && this.fCurrentURLClassLoader != null) {
            this.fCurrentURLClassLoader.debugSetDoRecordClassCache(bl);
        }
    }

    public boolean debugGetDoRecordClassCache() {
        return this.fDoRecordClassCache;
    }

    public void debugSetDoUseURLClassLoader(boolean bl) {
        this.fUseURLClassLoader = bl;
    }

    public boolean debugGetDoUseURLClassLoader() {
        return this.fUseURLClassLoader;
    }

    public void debugPrintClassPath() {
        for (int i = 0; i < this.fFileSystemClassPath.length; ++i) {
            System.out.println(this.fFileSystemClassPath[i]);
        }
    }

    public void debugPrintNativeLibraryPath() {
        Enumeration enumeration = this.fNativeLibraryPath.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println((String)enumeration.nextElement());
        }
    }

    public Hashtable debugGetClassCache() {
        Hashtable hashtable = null;
        if (this.fCurrentURLClassLoader != null) {
            hashtable = this.fCurrentURLClassLoader.debugGetClassCache();
        }
        return hashtable;
    }

    public static ClassLoader getStandaloneClassLoader(String string, String string2, ClassLoader classLoader) {
        return new StandaloneURLClassLoader(string, string2, classLoader);
    }

    public static ClassLoader getStandaloneClassLoader(String[] stringArray, String[] stringArray2, ClassLoader classLoader) {
        return new StandaloneURLClassLoader(stringArray, stringArray2, classLoader);
    }

    static class StandaloneURLClassLoader
    extends URLClassLoader {
        private Vector vecLibPath = new Vector();

        public StandaloneURLClassLoader(String string, String string2, ClassLoader classLoader) {
            super(new URL[]{}, classLoader != null ? classLoader : StandaloneURLClassLoader.getSystemClassLoader());
            this.addToClassPath(string);
            this.addToLibPath(string2);
        }

        public StandaloneURLClassLoader(String[] stringArray, String[] stringArray2, ClassLoader classLoader) {
            super(new URL[]{}, classLoader != null ? classLoader : StandaloneURLClassLoader.getSystemClassLoader());
            this.addToClassPath(stringArray);
            this.addToLibPath(stringArray2);
        }

        private void addToClassPath(String string) {
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.addElementToClassPath(string2);
            }
        }

        private void addToClassPath(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElementToClassPath(stringArray[i]);
            }
        }

        private void addToLibPath(String string) {
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.addElementToLibPath(string2);
            }
        }

        private void addToLibPath(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElementToClassPath(stringArray[i]);
            }
        }

        private void addElementToClassPath(String string) {
            if (string == null) {
                return;
            }
            File file = new File(string);
            if (file.exists()) {
                try {
                    URL uRL = file.toURI().toURL();
                    this.addURL(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        private void addElementToLibPath(String string) {
            if (string == null) {
                return;
            }
            File file = new File(string);
            if (file.exists()) {
                this.vecLibPath.add(string);
            }
        }

        protected String findLibrary(String string) {
            for (String string2 : this.vecLibPath) {
                File file = new File(string2 + File.separator + System.mapLibraryName(string));
                if (!file.exists()) continue;
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }

        public InputStream getResourceAsStream(String string) {
            if ("META-INF/services/javax.xml.parsers.DocumentBuilderFactory".equals(string)) {
                return new StringBufferInputStream("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            }
            if ("META-INF/services/javax.xml.parsers.SAXParserFactory".equals(string)) {
                return new StringBufferInputStream("org.apache.xerces.jaxp.SAXParserFactoryImpl");
            }
            if ("META-INF/services/javax.xml.transform.TransformerFactory".equals(string)) {
                return new StringBufferInputStream("com.icl.saxon.TransformerFactoryImpl");
            }
            return super.getResourceAsStream(string);
        }
    }
}

