/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.ClassLoaderManager;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CustomURLClassLoader
extends URLClassLoader {
    private int fDebuggingID;
    private Hashtable fCache;
    private boolean fIsValid = true;
    private int fVerboseLevel = 0;
    private boolean fDoRecordClassCache = false;
    private Vector fNativeLibraryPath = null;
    private boolean fIsLocked = false;

    public void setVerbose(int n) {
        this.fVerboseLevel = n;
    }

    public int getVerboseLevel() {
        return this.fVerboseLevel;
    }

    CustomURLClassLoader(ClassLoader classLoader, URL[] uRLArray, Vector vector, int n, boolean bl, int n2) {
        super(uRLArray, classLoader);
        this.fDebuggingID = n;
        this.fDoRecordClassCache = bl;
        this.fVerboseLevel = n2;
        this.fNativeLibraryPath = vector;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        if (this.fVerboseLevel >= 2) {
            System.out.println("Searching for class in file system: " + string);
        }
        if (this.fDoRecordClassCache) {
            return this.findClassWithDiagnostics(string);
        }
        return super.findClass(string);
    }

    public Class findClassWithDiagnostics(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = super.findClass(string);
        if (clazz != null) {
            if (this.fCache == null) {
                this.fCache = new Hashtable(50);
            }
            this.fCache.put(clazz, string);
        }
        return clazz;
    }

    public URL findResource(String string) {
        if (this.fVerboseLevel >= 2) {
            System.out.println("findResource: " + string);
        }
        return super.findResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        if (this.fVerboseLevel >= 2) {
            System.out.println("getResourceAsStream: " + string);
        }
        return super.getResourceAsStream(string);
    }

    protected void finalize() throws Throwable {
        if (this.fVerboseLevel >= 2) {
            System.out.println("Garbage collected InternetClassLoader. ID: " + this.fDebuggingID);
        }
        super.finalize();
    }

    protected String findLibrary(String string) {
        String string2 = null;
        String string3 = System.getProperty("file.separator");
        String string4 = null;
        File file = null;
        string = System.mapLibraryName(string);
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 1) {
            System.out.println("FileSystem:findLibrary: " + string);
        }
        Enumeration enumeration = this.fNativeLibraryPath.elements();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            file = new File(string4 + string3 + string);
            if (!file.isFile()) continue;
            string2 = file.getAbsolutePath();
            if (ClassLoaderManager.getCurrentVerboseLevel() >= 1) {
                System.out.println("Loaded native library: " + string + " from " + string2);
            }
            this.fIsLocked = true;
            break;
        }
        return string2;
    }

    public boolean isLocked() {
        return false;
    }

    public void setValid(boolean bl) {
        this.fIsValid = bl;
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public void debugSetDoRecordClassCache(boolean bl) {
        this.fDoRecordClassCache = bl;
    }

    public Hashtable debugGetClassCache() {
        return this.fCache;
    }
}

