/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.common.icons.FileTypeIcon;
import com.mathworks.common.icons.FolderIcon;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.services.Prefs;
import com.mathworks.util.FileUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public final class MLFileIconUtils {
    private static final boolean IS_BATSERVE = "batserve".equals(System.getProperties().getProperty("user.name"));
    private static final JFileChooser sChooser = PlatformInfo.isMacintosh() ? new JFileChooser() : null;
    private static final ImageIcon[] sFilePic;
    private static Map<String, Icon> sFileIconTable;
    private static final String[] sCachedFileExtensions;
    private static final int FOLDER_PIC = 0;
    private static final int M_PIC = 1;
    private static final int MAT_PIC = 2;
    private static final int P_PIC = 3;
    private static final int MDL_PIC = 4;
    private static final int RTW_PIC = 5;
    private static final int HTML_PIC = 6;
    private static final int MEX_PIC = 7;
    private static final int PDF_PIC = 8;
    private static final int DATA_PIC = 9;
    private static final int DOC_PIC = 10;
    private static final int MATLAB_PIC = 11;
    private static final int MATLAB_PROJECT = 12;
    private static final Map<Long, Icon> sSystemImageList;

    private MLFileIconUtils() {
    }

    public static Icon getFileIcon(File file, boolean bl) {
        if (bl && PlatformInfo.isXWindows()) {
            return MLFileIconUtils.getGenericFolderIcon();
        }
        Icon icon = null;
        String string = file.getName();
        if (!bl) {
            icon = MLFileIconUtils.getMatlabFileIcon(string);
        }
        if (icon == null) {
            icon = MLFileIconUtils.getNativeFileIcon(file, bl);
        }
        if (icon == null) {
            icon = MLFileIconUtils.getNonMatlabFileIcon(string, bl);
        }
        return icon;
    }

    private static Icon getGenericFolderIcon() {
        return sFilePic[0];
    }

    private static Icon getMatlabFileIcon(String string) {
        ImageIcon imageIcon = null;
        if (MLFileUtils.isMFile(string) || MLFileUtils.isReportGenFile(string)) {
            imageIcon = sFilePic[1];
        } else if (MLFileUtils.isMatFile(string)) {
            imageIcon = sFilePic[2];
        } else if (MLFileUtils.isPFile(string)) {
            imageIcon = sFilePic[3];
        } else if (MLFileUtils.isMdlFile(string)) {
            imageIcon = sFilePic[4];
        } else if (MLFileUtils.isRealtimeMatlabFile(string)) {
            imageIcon = sFilePic[5];
        } else if (MLFileUtils.isFigFile(string)) {
            imageIcon = sFilePic[11];
        } else if (MLFileUtils.isMexFile(string)) {
            imageIcon = sFilePic[7];
        } else if (FileUtils.isHtmlFile((String)string)) {
            imageIcon = sFilePic[6];
        } else if (PlatformInfo.isXWindows() && FileUtils.isPdfFile((String)string)) {
            imageIcon = sFilePic[8];
        }
        return imageIcon;
    }

    private static Icon getFastNativeIcon(File file, boolean bl) {
        String string = NativeJava.getNormalizedWindowsPath((File)file);
        long l = NativeJava.getFileIconIndex((String)string, (boolean)bl);
        if (sSystemImageList.get(l) != null) {
            return sSystemImageList.get(l);
        }
        int[] nArray = new int[256];
        if (NativeJava.getFileIcon((String)string, (boolean)bl, (int[])nArray)) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            bufferedImage.setRGB(0, 0, 16, 16, nArray, 0, 16);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            if (sSystemImageList.size() < 1024) {
                sSystemImageList.put(l, imageIcon);
            }
            return imageIcon;
        }
        return null;
    }

    private static synchronized Icon getNativeFileIcon(File file, boolean bl) {
        Icon icon = null;
        if (!PlatformInfo.isXWindows() && !IS_BATSERVE) {
            String string = MLFileIconUtils.getFileExtension(file.getName());
            if (!bl && MLFileIconUtils.inCachedList(string) && string != null && string.length() > 0) {
                icon = sFileIconTable.get(string);
            }
            if (icon == null) {
                if (PlatformInfo.isWindows() && !Prefs.getBooleanPref((String)"DocumentsNoNativeIcons") && (icon = MLFileIconUtils.getFastNativeIcon(file, bl)) != null && !bl && MLFileIconUtils.inCachedList(string)) {
                    sFileIconTable.put(string, icon);
                }
                if (icon == null && file.exists()) {
                    try {
                        ShellFolder.getShellFolder(file);
                        try {
                            icon = sChooser != null ? sChooser.getIcon(file) : FileSystemView.getFileSystemView().getSystemIcon(file);
                            if (!bl && MLFileIconUtils.inCachedList(string)) {
                                sFileIconTable.put(string, icon);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return icon;
    }

    private static boolean inCachedList(String string) {
        for (String string2 : sCachedFileExtensions) {
            if (string2.compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        return false;
    }

    private static String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n != -1 && n < string.length()) {
            string2 = string.substring(n + 1).toUpperCase(Locale.ENGLISH);
        }
        return string2;
    }

    private static Icon getNonMatlabFileIcon(String string, boolean bl) {
        if (bl) {
            return MLFileIconUtils.getGenericFolderIcon();
        }
        if (PlatformInfo.isWindows()) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if (string.endsWith(".gif") || string.endsWith(".cur") || string.endsWith(".hdf") || string.endsWith(".ico") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".mat") || string.endsWith(".avi") || string.endsWith(".png") || string.endsWith(".au") || string.endsWith(".snd") || string.endsWith(".wav") || string.endsWith(".csv") || string.endsWith(".xls") || string.endsWith(".xlsx") || string.endsWith(".wk1") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".dat") || string.endsWith(".dlm") || string.endsWith(".tab") || string.endsWith(".bmp") || string.endsWith(".pcx")) {
            return sFilePic[9];
        }
        return sFilePic[10];
    }

    static {
        sFileIconTable = new Hashtable<String, Icon>();
        sCachedFileExtensions = new String[]{"bak", ""};
        sSystemImageList = Collections.synchronizedMap(new HashMap());
        sFilePic = new ImageIcon[13];
        MLFileIconUtils.sFilePic[0] = FolderIcon.CLOSED.getIcon();
        MLFileIconUtils.sFilePic[1] = FileTypeIcon.M.getIcon();
        MLFileIconUtils.sFilePic[2] = FileTypeIcon.MAT.getIcon();
        MLFileIconUtils.sFilePic[3] = FileTypeIcon.P.getIcon();
        MLFileIconUtils.sFilePic[4] = FileTypeIcon.MDL.getIcon();
        MLFileIconUtils.sFilePic[5] = FileTypeIcon.MDL.getIcon();
        MLFileIconUtils.sFilePic[6] = FileTypeIcon.HTML.getIcon();
        MLFileIconUtils.sFilePic[7] = FileTypeIcon.GENERIC.getIcon();
        MLFileIconUtils.sFilePic[8] = FileTypeIcon.PDF.getIcon();
        MLFileIconUtils.sFilePic[9] = FileTypeIcon.DATA.getIcon();
        MLFileIconUtils.sFilePic[10] = FileTypeIcon.DOCUMENT.getIcon();
        MLFileIconUtils.sFilePic[11] = FileTypeIcon.FIG.getIcon();
        MLFileIconUtils.sFilePic[12] = FileTypeIcon.MATLAB_PROJECT.getIcon();
    }
}

