/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.NativeMatlab;
import java.awt.EventQueue;

public abstract class MatlabWorker {
    private Object fValue;
    private final MatlabMCR fMatlabMCR;
    private final Runnable fRunOnEDT = new Runnable(){

        public void run() {
            try {
                MatlabWorker.this.runOnAWTEventDispatchThread(MatlabWorker.this.getValue());
            }
            catch (Exception exception) {
                MatlabWorker.this.handleException(exception, false);
            }
        }
    };
    private final Runnable fRunOnMT = new Runnable(){

        public void run() {
            boolean bl = false;
            try {
                MatlabWorker.this.setValue(MatlabWorker.this.runOnMatlabThread());
                bl = true;
            }
            catch (Exception exception) {
                MatlabWorker.this.handleException(exception, true);
            }
            if (bl) {
                EventQueue.invokeLater(MatlabWorker.this.fRunOnEDT);
            }
        }
    };

    protected void handleException(Exception exception, boolean bl) {
        exception.printStackTrace();
    }

    private synchronized Object getValue() {
        return this.fValue;
    }

    private synchronized void setValue(Object object) {
        this.fValue = object;
    }

    protected static void eval(String string) throws Exception {
        Matlab.mtEval(string);
    }

    protected static Object eval(String string, int n) throws Exception {
        return Matlab.mtEval(string, n);
    }

    protected static Object feval(String string, Object[] objectArray, int n) throws Exception {
        return MatlabWorker.feval(string, objectArray, n, true);
    }

    protected static Object feval(String string, Object[] objectArray, int n, boolean bl) throws Exception {
        if (bl) {
            return Matlab.mtFevalConsoleOutput(string, objectArray, n);
        }
        return Matlab.mtFeval(string, objectArray, n);
    }

    public abstract Object runOnMatlabThread() throws Exception;

    public abstract void runOnAWTEventDispatchThread(Object var1);

    public MatlabWorker() {
        this(null);
    }

    public MatlabWorker(MatlabMCR matlabMCR) {
        this.fMatlabMCR = matlabMCR;
    }

    public void start() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            this.fRunOnMT.run();
        } else if (this.fMatlabMCR == null) {
            Matlab.whenMatlabIdle(this.fRunOnMT);
        } else {
            this.fMatlabMCR.whenMatlabIdle(this.fRunOnMT);
        }
    }
}

