/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.DynamicProperties;
import com.mathworks.jmi.bean.MTObject;
import com.mathworks.jmi.bean.TreeObject;
import com.mathworks.jmi.bean.UDDBeanClass;
import com.mathworks.jmi.bean.UDDBeanInfoUtil;
import com.mathworks.jmi.bean.UDDPropertyDescription;
import com.mathworks.services.Browseable;
import com.mathworks.services.BrowseableListener;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class UDDObject
implements TreeObject,
Browseable,
MTObject,
DynamicProperties {
    public static final int RELATION_UP = 0;
    public static final int RELATION_LEFT = 1;
    public static final int RELATION_RIGHT = 2;
    public static final int RELATION_FIRST_DOWN = 3;
    public static final int RELATION_LAST_DOWN = 4;
    protected final long fUDInterfacePointer;
    private int fRefCount;
    private transient int fIndex = 0;
    private transient boolean fCacheIsDirty = false;
    private UDDObject fLastReturnedChild;
    private int fLastReturnedChildIndex;
    private int fNumChildren;
    private static int sThreadSafetyCheckLevel = 2;

    public UDDObject(long l) {
        this.fUDInterfacePointer = l;
        this.updateChildCount();
        this.updateIndex();
    }

    public int hashCode() {
        return (int)(this.fUDInterfacePointer ^ this.fUDInterfacePointer >> 32);
    }

    public boolean isValid() {
        return this.fUDInterfacePointer != 0L;
    }

    public int compareTo(Object object) {
        return this.compareTo((UDDObject)object);
    }

    public int compareTo(UDDObject uDDObject) {
        long l = this.fUDInterfacePointer;
        long l2 = uDDObject.fUDInterfacePointer;
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            if (this.fUDInterfacePointer == uDDObject.fUDInterfacePointer) {
                return true;
            }
        }
        return false;
    }

    public String getClassName() {
        String string = null;
        Class<?> clazz = this.getClass();
        try {
            Field field = clazz.getField("sUDDClassName");
            string = (String)field.get(this);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println(noSuchFieldException);
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
        }
        return string;
    }

    public final Object getPropertyValue(String string) {
        Long l;
        Class<?> clazz = this.getClass();
        Object object = null;
        Hashtable hashtable = UDDBeanClass.getPropertyMap(clazz);
        if (hashtable != null && (l = (Long)hashtable.get(string)) != null) {
            object = this.get_from_Matlab(l);
        }
        return object;
    }

    public final void setPropertyValue(String string, Object object) {
        Long l;
        Class<?> clazz = this.getClass();
        Hashtable hashtable = UDDBeanClass.getPropertyMap(clazz);
        if (hashtable != null && (l = (Long)hashtable.get(string)) != null) {
            this.set_in_Matlab(l, object);
        }
    }

    public final TreeObject up() {
        return this.get_related_object(0);
    }

    public final TreeObject left() {
        return this.get_related_object(1);
    }

    public final TreeObject right() {
        return this.get_related_object(2);
    }

    public final TreeObject firstDown() {
        return this.get_related_object(3);
    }

    public final TreeObject lastDown() {
        return this.get_related_object(4);
    }

    public final void addBelow(TreeObject treeObject) {
    }

    public final void addFirstBelow(TreeObject treeObject) {
    }

    public final void addRight(TreeObject treeObject) {
    }

    public final void addLeft(TreeObject treeObject) {
    }

    private static native Object[] directGetPropertyFromMatlab(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object get_from_Matlab(long l) {
        Object[] objectArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directGetPropertyFromMatlab(this.fUDInterfacePointer, l);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabGet runMatlabGet = new RunMatlabGet(this.fUDInterfacePointer, l);
            Matlab.whenMatlabReady(runMatlabGet);
            RunMatlabGet runMatlabGet2 = runMatlabGet;
            synchronized (runMatlabGet2) {
                while (!runMatlabGet.executed) {
                    try {
                        runMatlabGet.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runMatlabGet.error == null) {
                    objectArray = runMatlabGet.result;
                }
            }
        }
        if (objectArray != null) {
            if (objectArray[1] != null) {
                throw new RuntimeException((String)objectArray[1]);
            }
            return objectArray[0];
        }
        return null;
    }

    private static native Object[] directSetPropertyInMatlab(long var0, long var2, Object var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void set_in_Matlab(long l, Object object) {
        Object[] objectArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directSetPropertyInMatlab(this.fUDInterfacePointer, l, object);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabSet runMatlabSet = new RunMatlabSet(this.fUDInterfacePointer, l, object);
            Matlab.whenMatlabReady(runMatlabSet);
            RunMatlabSet runMatlabSet2 = runMatlabSet;
            synchronized (runMatlabSet2) {
                while (!runMatlabSet.executed) {
                    try {
                        runMatlabSet.wait();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                if (runMatlabSet.error == null) {
                    objectArray = runMatlabSet.result;
                }
            }
        }
        if (objectArray != null && objectArray[1] != null) {
            throw new RuntimeException((String)objectArray[1]);
        }
    }

    private static native Object[] directSendEvent(long var0, String var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void sendEvent(String string, UDDObject uDDObject) {
        Object[] objectArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directSendEvent(this.fUDInterfacePointer, string, uDDObject == null ? 0L : uDDObject.fUDInterfacePointer);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabSend runMatlabSend = new RunMatlabSend(this.fUDInterfacePointer, string, uDDObject == null ? 0L : uDDObject.fUDInterfacePointer);
            Matlab.whenMatlabReady(runMatlabSend);
            RunMatlabSend runMatlabSend2 = runMatlabSend;
            synchronized (runMatlabSend2) {
                while (!runMatlabSend.executed) {
                    try {
                        runMatlabSend.wait();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                if (runMatlabSend.error == null) {
                    objectArray = runMatlabSend.result;
                }
            }
        }
        if (objectArray != null && objectArray[1] != null) {
            throw new RuntimeException((String)objectArray[1]);
        }
    }

    private static native Object[] directInvokeInMatlab(long var0, long var2, long var4, Object[] var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object invokeMethod(long l, long l2, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray2 = UDDObject.directInvokeInMatlab(this.fUDInterfacePointer, l, l2, objectArray);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabInvoke runMatlabInvoke = new RunMatlabInvoke(this.fUDInterfacePointer, l, l2, objectArray);
            Matlab.whenMatlabReady(runMatlabInvoke);
            RunMatlabInvoke runMatlabInvoke2 = runMatlabInvoke;
            synchronized (runMatlabInvoke2) {
                while (!runMatlabInvoke.executed) {
                    try {
                        runMatlabInvoke.wait();
                    }
                    catch (Exception exception) {
                        return objectArray2;
                    }
                }
                if (runMatlabInvoke.error == null) {
                    objectArray2 = runMatlabInvoke.result;
                }
            }
        }
        if (objectArray2 != null) {
            if (objectArray2[1] != null) {
                throw new RuntimeException((String)objectArray2[1]);
            }
            return objectArray2[0];
        }
        return null;
    }

    private static native Object[] directGetRelatedObjectFromMatlab(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UDDObject get_related_object(int n) {
        Object[] objectArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directGetRelatedObjectFromMatlab(this.fUDInterfacePointer, n);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabGetRelatedObject runMatlabGetRelatedObject = new RunMatlabGetRelatedObject(this.fUDInterfacePointer, n);
            Matlab.whenMatlabReady(runMatlabGetRelatedObject);
            RunMatlabGetRelatedObject runMatlabGetRelatedObject2 = runMatlabGetRelatedObject;
            synchronized (runMatlabGetRelatedObject2) {
                while (!runMatlabGetRelatedObject.executed) {
                    try {
                        runMatlabGetRelatedObject.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runMatlabGetRelatedObject.error == null) {
                    objectArray = runMatlabGetRelatedObject.result;
                }
            }
        }
        if (objectArray != null) {
            if (objectArray[1] != null) {
                throw new RuntimeException((String)objectArray[1]);
            }
            return (UDDObject)objectArray[0];
        }
        return null;
    }

    public String toString() {
        return this.getClassName();
    }

    private static native String directGetDisplayNameFromMatlab(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String get_display_name() {
        String string = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                string = UDDObject.directGetDisplayNameFromMatlab(this.fUDInterfacePointer);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabGetDisplayName runMatlabGetDisplayName = new RunMatlabGetDisplayName(this.fUDInterfacePointer);
            Matlab.whenMatlabReady(runMatlabGetDisplayName);
            RunMatlabGetDisplayName runMatlabGetDisplayName2 = runMatlabGetDisplayName;
            synchronized (runMatlabGetDisplayName2) {
                while (!runMatlabGetDisplayName.executed) {
                    try {
                        runMatlabGetDisplayName.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runMatlabGetDisplayName.error == null) {
                    string = runMatlabGetDisplayName.result;
                }
            }
        }
        return string;
    }

    private static native void directGetInterfaceReference(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquireReference() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                UDDObject.directGetInterfaceReference(this.fUDInterfacePointer);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabAcquireReference runMatlabAcquireReference = new RunMatlabAcquireReference(this.fUDInterfacePointer);
            Matlab.whenMatlabReady(runMatlabAcquireReference);
            RunMatlabAcquireReference runMatlabAcquireReference2 = runMatlabAcquireReference;
            synchronized (runMatlabAcquireReference2) {
                while (!runMatlabAcquireReference.executed) {
                    try {
                        runMatlabAcquireReference.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        ++this.fRefCount;
    }

    private static native void directReleaseInterfaceReference(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseReference() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                UDDObject.directReleaseInterfaceReference(this.fUDInterfacePointer);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabReleaseReference runMatlabReleaseReference = new RunMatlabReleaseReference(this.fUDInterfacePointer);
            Matlab.whenMatlabReady(runMatlabReleaseReference);
            RunMatlabReleaseReference runMatlabReleaseReference2 = runMatlabReleaseReference;
            synchronized (runMatlabReleaseReference2) {
                while (!runMatlabReleaseReference.executed) {
                    try {
                        runMatlabReleaseReference.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        --this.fRefCount;
    }

    private static native Object[] directNewInstance(String var0, Object[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UDDObject getNewInstance(String string, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray2 = UDDObject.directNewInstance(string, objectArray);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabGetNewInstance runMatlabGetNewInstance = new RunMatlabGetNewInstance(string, objectArray);
            Matlab.whenMatlabReady(runMatlabGetNewInstance);
            RunMatlabGetNewInstance runMatlabGetNewInstance2 = runMatlabGetNewInstance;
            synchronized (runMatlabGetNewInstance2) {
                while (!runMatlabGetNewInstance.executed) {
                    try {
                        runMatlabGetNewInstance.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runMatlabGetNewInstance.error == null) {
                    objectArray2 = runMatlabGetNewInstance.result;
                }
            }
        }
        if (objectArray2 != null) {
            if (objectArray2[1] != null) {
                throw new RuntimeException((String)objectArray2[1]);
            }
            ++((UDDObject)objectArray2[0]).fRefCount;
            return (UDDObject)objectArray2[0];
        }
        return null;
    }

    private static native Object[] directFindProperty(long var0, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDDObject findProperty(String string) {
        Object[] objectArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directFindProperty(this.fUDInterfacePointer, string);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabFindProperty runMatlabFindProperty = new RunMatlabFindProperty(this.fUDInterfacePointer, string);
            Matlab.whenMatlabReady(runMatlabFindProperty);
            RunMatlabFindProperty runMatlabFindProperty2 = runMatlabFindProperty;
            synchronized (runMatlabFindProperty2) {
                while (!runMatlabFindProperty.executed) {
                    try {
                        runMatlabFindProperty.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runMatlabFindProperty.error == null) {
                    objectArray = runMatlabFindProperty.result;
                }
            }
        }
        if (objectArray != null) {
            if (objectArray[1] != null) {
                throw new RuntimeException((String)objectArray[1]);
            }
            return (UDDObject)objectArray[0];
        }
        return null;
    }

    private static native void directDisposeOfObject(long var0);

    public synchronized void dispose() {
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                long l = this.fUDInterfacePointer;
                UDDObject.directDisposeOfObject(this.fUDInterfacePointer);
                while (this.fRefCount > 0) {
                    --this.fRefCount;
                    UDDObject.directReleaseInterfaceReference(l);
                }
            }
            catch (Exception exception) {}
        } else {
            RunDispose runDispose = new RunDispose(this.fUDInterfacePointer, this.fRefCount);
            Matlab.whenMatlabReady(runDispose);
        }
    }

    protected final void set_value(long l, boolean bl) {
        this.set_in_Matlab(l, new Boolean(bl));
    }

    protected final void set_value(long l, byte by) {
        this.set_in_Matlab(l, new Byte(by));
    }

    protected final void set_value(long l, char c) {
        this.set_in_Matlab(l, new Character(c));
    }

    protected final void set_value(long l, short s) {
        this.set_in_Matlab(l, new Short(s));
    }

    protected final void set_value(long l, int n) {
        this.set_in_Matlab(l, new Integer(n));
    }

    protected final void set_value(long l, long l2) {
        this.set_in_Matlab(l, new Long(l2));
    }

    protected final void set_value(long l, double d) {
        this.set_in_Matlab(l, new Double(d));
    }

    protected final void set_value(long l, float f) {
        this.set_in_Matlab(l, new Float(f));
    }

    protected final void set_value(long l, Object object) {
        this.set_in_Matlab(l, object);
    }

    protected final boolean get_boolean_value(long l) {
        Boolean bl = (Boolean)this.get_from_Matlab(l);
        boolean bl2 = bl == null ? false : bl;
        return bl2;
    }

    protected final byte get_byte_value(long l) {
        Byte by = (Byte)this.get_from_Matlab(l);
        byte by2 = by == null ? (byte)0 : by;
        return by2;
    }

    protected final char get_char_value(long l) {
        Character c = (Character)this.get_from_Matlab(l);
        char c2 = c == null ? (char)'\u0000' : c.charValue();
        return c2;
    }

    protected final short get_short_value(long l) {
        Short s = (Short)this.get_from_Matlab(l);
        short s2 = s == null ? (short)0 : s;
        return s2;
    }

    protected final int get_int_value(long l) {
        Integer n = (Integer)this.get_from_Matlab(l);
        int n2 = n == null ? 0 : n;
        return n2;
    }

    protected final long get_long_value(long l) {
        Long l2 = (Long)this.get_from_Matlab(l);
        long l3 = l2 == null ? 0L : l2;
        return l3;
    }

    protected final double get_double_value(long l) {
        Double d = (Double)this.get_from_Matlab(l);
        double d2 = d == null ? 0.0 : d;
        return d2;
    }

    protected final float get_float_value(long l) {
        Float f = (Float)this.get_from_Matlab(l);
        float f2 = f == null ? 0.0f : f.floatValue();
        return f2;
    }

    protected final Object get_Object_value(long l) {
        return this.get_from_Matlab(l);
    }

    public final Object browseableDisplayObject() {
        return this.get_display_name();
    }

    public final Object browseableDataObject() {
        return this;
    }

    public final Browseable browseableParent() {
        return this.get_related_object(0);
    }

    public final boolean browseableHasChildren() {
        return this.get_related_object(3) != null;
    }

    public final boolean browseableCanHaveChildren() {
        return true;
    }

    public final int browseableChildCount() {
        return this.fNumChildren;
    }

    public final Browseable browseableChild(int n) {
        if (this.fLastReturnedChild == null) {
            this.fLastReturnedChild = this.get_related_object(3);
            this.fLastReturnedChildIndex = 0;
        }
        int n2 = 2;
        int n3 = 1;
        if (this.fLastReturnedChildIndex > n) {
            n2 = 1;
            n3 = -1;
        }
        while (this.fLastReturnedChildIndex != n) {
            this.fLastReturnedChild = this.fLastReturnedChild.get_related_object(n2);
            this.fLastReturnedChildIndex += n3;
        }
        return this.fLastReturnedChild;
    }

    public final Browseable[] browseableChildren() {
        return this.browseableNChildren(0, this.fNumChildren);
    }

    public final Browseable[] browseableNChildren(int n, int n2) {
        int n3;
        UDDObject[] uDDObjectArray = null;
        int n4 = n3 = n2 + n > this.fNumChildren ? this.fNumChildren - n : n2;
        if (n3 > 0) {
            uDDObjectArray = new UDDObject[n3];
            uDDObjectArray[0] = (UDDObject)this.browseableChild(n);
            for (int i = 1; i < n3; ++i) {
                uDDObjectArray[i] = uDDObjectArray[i - 1].get_related_object(2);
            }
        }
        return uDDObjectArray;
    }

    public final Browseable browseableNextSibling() {
        return this.get_related_object(2);
    }

    private final Browseable[] getNSiblings(int n, int n2) {
        Browseable[] browseableArray = new UDDObject[n];
        UDDObject uDDObject = this;
        int n3 = 0;
        while (uDDObject != null && n3 < n) {
            browseableArray[n3++] = uDDObject.get_related_object(n2);
        }
        if (n3 > 0) {
            if (n3 < n) {
                UDDObject[] uDDObjectArray = new UDDObject[n3];
                System.arraycopy(browseableArray, 0, uDDObjectArray, 0, n3);
                browseableArray = uDDObjectArray;
            }
        } else {
            browseableArray = null;
        }
        return browseableArray;
    }

    public final Browseable[] browseableNextNSiblings(int n) {
        return this.getNSiblings(n, 2);
    }

    public final Browseable browseablePrevSibling() {
        return this.get_related_object(1);
    }

    public final Browseable[] browseablePrevNSiblings(int n) {
        return this.getNSiblings(n, 1);
    }

    public final int browseableChildFetchCount() {
        return 10;
    }

    public final void addBrowseableListener(BrowseableListener browseableListener) {
    }

    public final void removeBrowseableListener(BrowseableListener browseableListener) {
    }

    public boolean isLeaf() {
        return false;
    }

    private static native int directGetIndexOfChild(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfChild(UDDObject uDDObject) {
        int n = -1;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                n = UDDObject.directGetIndexOfChild(this.fUDInterfacePointer, uDDObject.fUDInterfacePointer);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunGetIndexOfChild runGetIndexOfChild = new RunGetIndexOfChild(this.fUDInterfacePointer, uDDObject.fUDInterfacePointer);
            Matlab.whenMatlabReady(runGetIndexOfChild);
            RunGetIndexOfChild runGetIndexOfChild2 = runGetIndexOfChild;
            synchronized (runGetIndexOfChild2) {
                while (!runGetIndexOfChild.executed) {
                    try {
                        runGetIndexOfChild.wait();
                    }
                    catch (Exception exception) {
                        return n;
                    }
                }
                if (runGetIndexOfChild.error == null) {
                    n = runGetIndexOfChild.result;
                }
            }
        }
        return n;
    }

    private static native Object directGetChildAt(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UDDObject getChildAt(int n) {
        Object object = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                object = UDDObject.directGetChildAt(this.fUDInterfacePointer, n);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunGetChildAt runGetChildAt = new RunGetChildAt(this.fUDInterfacePointer, n);
            Matlab.whenMatlabReady(runGetChildAt);
            RunGetChildAt runGetChildAt2 = runGetChildAt;
            synchronized (runGetChildAt2) {
                while (!runGetChildAt.executed) {
                    try {
                        runGetChildAt.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runGetChildAt.error == null) {
                    object = runGetChildAt.result;
                }
            }
        }
        if (object != null) {
            return (UDDObject)object;
        }
        throw new ArrayIndexOutOfBoundsException("node has no children");
    }

    public void updateIndex() {
        UDDObject uDDObject = this.get_related_object(0);
        this.fIndex = uDDObject == null ? 0 : uDDObject.getIndexOfChild(this);
    }

    public int getIndex() {
        return this.fIndex;
    }

    private static native int directGetNumChildren(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChildCount() {
        int n = 0;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                n = UDDObject.directGetNumChildren(this.fUDInterfacePointer);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunGetNumChildren runGetNumChildren = new RunGetNumChildren(this.fUDInterfacePointer);
            Matlab.whenMatlabReady(runGetNumChildren);
            RunGetNumChildren runGetNumChildren2 = runGetNumChildren;
            synchronized (runGetNumChildren2) {
                while (!runGetNumChildren.executed) {
                    try {
                        runGetNumChildren.wait();
                    }
                    catch (Exception exception) {}
                }
                if (runGetNumChildren.error == null) {
                    n = runGetNumChildren.result;
                }
            }
        }
        this.fNumChildren = n;
    }

    public int getChildCount() {
        return this.getChildCount(this);
    }

    public int getChildCount(Object object) {
        UDDObject uDDObject = (UDDObject)object;
        this.updateCache(uDDObject);
        return uDDObject.fNumChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirtyFlag() {
        UDDObject uDDObject = this;
        synchronized (uDDObject) {
            this.fCacheIsDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDirtyFlag() {
        UDDObject uDDObject = this;
        synchronized (uDDObject) {
            this.fCacheIsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        UDDObject uDDObject = this;
        synchronized (uDDObject) {
            return this.fCacheIsDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache(Object object) {
        if (object != null) {
            UDDObject uDDObject;
            UDDObject uDDObject2 = uDDObject = (UDDObject)object;
            synchronized (uDDObject2) {
                if (uDDObject.isDirty()) {
                    uDDObject.updateChildCount();
                    for (int i = 0; i < uDDObject.fNumChildren; ++i) {
                        UDDObject uDDObject3;
                        UDDObject uDDObject4 = uDDObject3 = uDDObject.getChildAt(i);
                        synchronized (uDDObject4) {
                            uDDObject3.updateIndex();
                            continue;
                        }
                    }
                    uDDObject.clearDirtyFlag();
                }
            }
        }
    }

    public static void setThreadSafetyCheckLevel(int n) {
        sThreadSafetyCheckLevel = n;
    }

    public static void checkThreadSafety() {
        if (sThreadSafetyCheckLevel > 0 && SwingUtilities.isEventDispatchThread()) {
            String string = "Unsafe synchronous call to MATLAB from the Event Dispatch Thread";
            Error error = new Error(string);
            if (sThreadSafetyCheckLevel > 1) {
                error.printStackTrace();
            } else {
                throw error;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PropertyDescriptor[] getDynamicProperties() {
        Object[] objectArray = null;
        PropertyDescriptor[] propertyDescriptorArray = null;
        UDDPropertyDescription[] uDDPropertyDescriptionArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directGetDynamicProperties(this.fUDInterfacePointer);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabGetDynamicProperties runMatlabGetDynamicProperties = new RunMatlabGetDynamicProperties(this.fUDInterfacePointer);
            Matlab.whenMatlabReady(runMatlabGetDynamicProperties);
            RunMatlabGetDynamicProperties runMatlabGetDynamicProperties2 = runMatlabGetDynamicProperties;
            synchronized (runMatlabGetDynamicProperties2) {
                while (!runMatlabGetDynamicProperties.executed) {
                    try {
                        runMatlabGetDynamicProperties.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runMatlabGetDynamicProperties.error == null) {
                    objectArray = runMatlabGetDynamicProperties.result;
                }
            }
        }
        if (objectArray != null) {
            if (objectArray[1] != null) {
                throw new RuntimeException((String)objectArray[1]);
            }
            uDDPropertyDescriptionArray = (UDDPropertyDescription[])objectArray[0];
            int n = uDDPropertyDescriptionArray.length;
            propertyDescriptorArray = new PropertyDescriptor[n];
            for (int i = 0; i < uDDPropertyDescriptionArray.length; ++i) {
                try {
                    propertyDescriptorArray[i] = UDDBeanInfoUtil.createDynamicPropertyDescriptor(uDDPropertyDescriptionArray[i]);
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    introspectionException.printStackTrace();
                }
            }
            return propertyDescriptorArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getDynamicPropertyValue(String string) {
        Object[] objectArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directGetDynamicPropertyValue(this.fUDInterfacePointer, string);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabGetDynamicProperty runMatlabGetDynamicProperty = new RunMatlabGetDynamicProperty(this.fUDInterfacePointer, string);
            Matlab.whenMatlabReady(runMatlabGetDynamicProperty);
            RunMatlabGetDynamicProperty runMatlabGetDynamicProperty2 = runMatlabGetDynamicProperty;
            synchronized (runMatlabGetDynamicProperty2) {
                while (!runMatlabGetDynamicProperty.executed) {
                    try {
                        runMatlabGetDynamicProperty.wait();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (runMatlabGetDynamicProperty.error == null) {
                    objectArray = runMatlabGetDynamicProperty.result;
                }
            }
        }
        if (objectArray != null) {
            if (objectArray[1] != null) {
                throw new RuntimeException((String)objectArray[1]);
            }
            return objectArray[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDynamicPropertyValue(String string, Object object) {
        Object[] objectArray = null;
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                objectArray = UDDObject.directSetDynamicPropertyValue(this.fUDInterfacePointer, string, object);
            }
            catch (Exception exception) {}
        } else {
            UDDObject.checkThreadSafety();
            RunMatlabSetDynamicPropertyValue runMatlabSetDynamicPropertyValue = new RunMatlabSetDynamicPropertyValue(this.fUDInterfacePointer, string, object);
            Matlab.whenMatlabReady(runMatlabSetDynamicPropertyValue);
            RunMatlabSetDynamicPropertyValue runMatlabSetDynamicPropertyValue2 = runMatlabSetDynamicPropertyValue;
            synchronized (runMatlabSetDynamicPropertyValue2) {
                while (!runMatlabSetDynamicPropertyValue.executed) {
                    try {
                        runMatlabSetDynamicPropertyValue.wait();
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                if (runMatlabSetDynamicPropertyValue.error == null) {
                    objectArray = runMatlabSetDynamicPropertyValue.result;
                }
            }
        }
        if (objectArray != null && objectArray[1] != null) {
            throw new RuntimeException((String)objectArray[1]);
        }
    }

    private static native Object[] directGetDynamicProperties(long var0);

    private static native Object[] directGetDynamicPropertyValue(long var0, String var2);

    private static native Object[] directSetDynamicPropertyValue(long var0, String var2, Object var3);

    class RunMatlabSetDynamicPropertyValue
    implements Runnable {
        private long fObjectPtr;
        private String fPropPtr;
        private Object fValue;
        public Object[] result;
        public Exception error;
        public boolean executed = false;

        public RunMatlabSetDynamicPropertyValue(long l, String string, Object object) {
            this.fObjectPtr = l;
            this.fPropPtr = string;
            this.fValue = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directSetDynamicPropertyValue(this.fObjectPtr, this.fPropPtr, this.fValue);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabSetDynamicPropertyValue runMatlabSetDynamicPropertyValue = this;
            synchronized (runMatlabSetDynamicPropertyValue) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabGetDynamicProperty
    implements Runnable {
        private long fObjectPtr;
        private String fPropPtr;
        public Object[] result;
        public boolean executed = false;
        public Exception error;

        public RunMatlabGetDynamicProperty(long l, String string) {
            this.fObjectPtr = l;
            this.fPropPtr = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directGetDynamicPropertyValue(this.fObjectPtr, this.fPropPtr);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabGetDynamicProperty runMatlabGetDynamicProperty = this;
            synchronized (runMatlabGetDynamicProperty) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabGetDynamicProperties
    implements Runnable {
        private long fObjectPtr;
        public Object[] result;
        public boolean executed = false;
        public Exception error;

        public RunMatlabGetDynamicProperties(long l) {
            this.fObjectPtr = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directGetDynamicProperties(this.fObjectPtr);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabGetDynamicProperties runMatlabGetDynamicProperties = this;
            synchronized (runMatlabGetDynamicProperties) {
                this.notifyAll();
            }
        }
    }

    class RunGetNumChildren
    implements Runnable {
        private long fParentPtr;
        public int result = 0;
        public boolean executed = false;
        public Exception error;

        public RunGetNumChildren(long l) {
            this.fParentPtr = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directGetNumChildren(this.fParentPtr);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunGetNumChildren runGetNumChildren = this;
            synchronized (runGetNumChildren) {
                this.notifyAll();
            }
        }
    }

    class RunGetChildAt
    implements Runnable {
        private long fParentPtr;
        private int fIdx;
        public Exception error;
        public Object result = null;
        public boolean executed = false;

        public RunGetChildAt(long l, int n) {
            this.fParentPtr = l;
            this.fIdx = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directGetChildAt(this.fParentPtr, this.fIdx);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunGetChildAt runGetChildAt = this;
            synchronized (runGetChildAt) {
                this.notifyAll();
            }
        }
    }

    class RunGetIndexOfChild
    implements Runnable {
        private long fParentPtr;
        private long fChildPtr;
        public Exception error;
        public int result = -1;
        public boolean executed = false;

        public RunGetIndexOfChild(long l, long l2) {
            this.fParentPtr = l;
            this.fChildPtr = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directGetIndexOfChild(this.fParentPtr, this.fChildPtr);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunGetIndexOfChild runGetIndexOfChild = this;
            synchronized (runGetIndexOfChild) {
                this.notifyAll();
            }
        }
    }

    class RunDispose
    implements Runnable {
        private long fObjectPtr;
        private int fRefCount;

        public RunDispose(long l, int n) {
            this.fObjectPtr = l;
            this.fRefCount = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                UDDObject.directDisposeOfObject(this.fObjectPtr);
                while (this.fRefCount > 0) {
                    --this.fRefCount;
                    UDDObject.directReleaseInterfaceReference(this.fObjectPtr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            RunDispose runDispose = this;
            synchronized (runDispose) {
                this.notifyAll();
            }
        }
    }

    static class RunMatlabFindProperty
    implements Runnable {
        private long fObj;
        private String fName;
        public Exception error;
        public Object[] result;
        public boolean executed = false;

        public RunMatlabFindProperty(long l, String string) {
            this.fObj = l;
            this.fName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void run() {
            try {
                this.result = UDDObject.directFindProperty(this.fObj, this.fName);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabFindProperty runMatlabFindProperty = this;
            synchronized (runMatlabFindProperty) {
                this.notifyAll();
            }
        }
    }

    static class RunMatlabGetNewInstance
    implements Runnable {
        private String name;
        private Object[] args;
        public Exception error;
        public Object[] result;
        public boolean executed = false;

        public RunMatlabGetNewInstance(String string, Object[] objectArray) {
            this.name = string;
            this.args = objectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void run() {
            try {
                this.result = UDDObject.directNewInstance(this.name, this.args);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabGetNewInstance runMatlabGetNewInstance = this;
            synchronized (runMatlabGetNewInstance) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabReleaseReference
    implements Runnable {
        private long theObj;
        public boolean executed = false;

        public RunMatlabReleaseReference(long l) {
            this.theObj = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void run() {
            try {
                UDDObject.directReleaseInterfaceReference(this.theObj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.executed = true;
            RunMatlabReleaseReference runMatlabReleaseReference = this;
            synchronized (runMatlabReleaseReference) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabAcquireReference
    implements Runnable {
        private long theObj;
        public boolean executed = false;

        public RunMatlabAcquireReference(long l) {
            this.theObj = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void run() {
            try {
                UDDObject.directGetInterfaceReference(this.theObj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.executed = true;
            RunMatlabAcquireReference runMatlabAcquireReference = this;
            synchronized (runMatlabAcquireReference) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabGetDisplayName
    implements Runnable {
        private long fObjectPtr;
        private Exception error;
        public String result;
        public boolean executed = false;

        public RunMatlabGetDisplayName(long l) {
            this.fObjectPtr = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void run() {
            try {
                this.result = UDDObject.directGetDisplayNameFromMatlab(this.fObjectPtr);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabGetDisplayName runMatlabGetDisplayName = this;
            synchronized (runMatlabGetDisplayName) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabGetRelatedObject
    implements Runnable {
        private long fObjectPtr;
        private int fRelation;
        private Exception error;
        public Object[] result;
        public boolean executed = false;

        public RunMatlabGetRelatedObject(long l, int n) {
            this.fObjectPtr = l;
            this.fRelation = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void run() {
            try {
                this.result = UDDObject.directGetRelatedObjectFromMatlab(this.fObjectPtr, this.fRelation);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabGetRelatedObject runMatlabGetRelatedObject = this;
            synchronized (runMatlabGetRelatedObject) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabInvoke
    implements Runnable {
        private long fObjectPtr;
        private long fMethodPtr;
        private long fSigPtr;
        private Object[] fArgs;
        private Exception error;
        public boolean executed = false;
        public Object[] result = null;

        public RunMatlabInvoke(long l, long l2, long l3, Object[] objectArray) {
            this.fObjectPtr = l;
            this.fMethodPtr = l2;
            this.fSigPtr = l3;
            this.fArgs = objectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directInvokeInMatlab(this.fObjectPtr, this.fMethodPtr, this.fSigPtr, this.fArgs);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabInvoke runMatlabInvoke = this;
            synchronized (runMatlabInvoke) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabSend
    implements Runnable {
        private long fObjectPtr;
        private long fEventData;
        private String fEventName;
        public Exception error;
        public Object[] result;
        public boolean executed = false;

        public RunMatlabSend(long l, String string, long l2) {
            this.fObjectPtr = l;
            this.fEventData = l2;
            this.fEventName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directSendEvent(this.fObjectPtr, this.fEventName, this.fEventData);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabSend runMatlabSend = this;
            synchronized (runMatlabSend) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabSet
    implements Runnable {
        private long fObjectPtr;
        private long fPropPtr;
        private Object fValue;
        public Exception error;
        public Object[] result;
        public boolean executed = false;

        public RunMatlabSet(long l, long l2, Object object) {
            this.fObjectPtr = l;
            this.fPropPtr = l2;
            this.fValue = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directSetPropertyInMatlab(this.fObjectPtr, this.fPropPtr, this.fValue);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabSet runMatlabSet = this;
            synchronized (runMatlabSet) {
                this.notifyAll();
            }
        }
    }

    class RunMatlabGet
    implements Runnable {
        private long fObjectPtr;
        private long fPropPtr;
        public Object[] result;
        public boolean executed = false;
        public Exception error;

        public RunMatlabGet(long l, long l2) {
            this.fObjectPtr = l;
            this.fPropPtr = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                this.result = UDDObject.directGetPropertyFromMatlab(this.fObjectPtr, this.fPropPtr);
            }
            catch (Exception exception) {
                this.error = exception;
            }
            this.executed = true;
            RunMatlabGet runMatlabGet = this;
            synchronized (runMatlabGet) {
                this.notifyAll();
            }
        }
    }
}

