/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UDDObjectTreeModel
implements TreeModel {
    protected UDDObject fRoot = null;
    protected EventListenerList fListenerList = new EventListenerList();
    protected Hashtable fUDDListeners = new Hashtable();
    protected Vector fLeafClasses = new Vector();

    public UDDObjectTreeModel(UDDObject uDDObject) {
        if (uDDObject == null) {
            throw new IllegalArgumentException("root is null");
        }
        this.fRoot = uDDObject;
        this.addAsListener(this.fRoot);
    }

    public UDDObjectTreeModel(UDDObject uDDObject, String[] stringArray) {
        if (uDDObject == null) {
            throw new IllegalArgumentException("root is null");
        }
        this.fRoot = uDDObject;
        this.addAsListener(this.fRoot);
        for (int i = 0; i < stringArray.length; ++i) {
            this.fLeafClasses.addElement(stringArray[i]);
        }
    }

    protected void nodesWereInserted(UDDObject uDDObject, int[] nArray, Object[] objectArray) {
        this.fireTreeNodesInserted(this, this.getPathToRoot(uDDObject), nArray, objectArray);
    }

    protected void nodesWereRemoved(UDDObject uDDObject, int[] nArray, Object[] objectArray) {
        this.fireTreeNodesRemoved(this, this.getPathToRoot(uDDObject), nArray, objectArray);
    }

    protected void updateChildIndices(UDDObject uDDObject) {
        this.updateChildIndices(uDDObject, 0);
    }

    protected void updateChildIndices(UDDObject uDDObject, int n) {
        for (UDDObject uDDObject2 = (UDDObject)uDDObject.firstDown(); uDDObject2 != null; uDDObject2 = (UDDObject)uDDObject2.right()) {
            if (uDDObject2.getIndex() != n) continue;
            while (uDDObject2 != null) {
                uDDObject2.updateIndex();
                uDDObject2 = (UDDObject)uDDObject2.right();
            }
            break;
        }
    }

    private void addAsListener(UDDObject uDDObject) {
        if (!this.fUDDListeners.containsKey(uDDObject)) {
            NodesInsertedListener nodesInsertedListener = new NodesInsertedListener(uDDObject);
            NodesRemovedListener nodesRemovedListener = new NodesRemovedListener(uDDObject);
            UDDListenerAggregate uDDListenerAggregate = new UDDListenerAggregate(nodesInsertedListener, nodesRemovedListener);
            this.fUDDListeners.put(uDDObject, uDDListenerAggregate);
        }
    }

    private void removeAsListener(UDDObject uDDObject) {
        if (this.fUDDListeners.containsKey(uDDObject)) {
            UDDListenerAggregate uDDListenerAggregate = (UDDListenerAggregate)this.fUDDListeners.get(uDDObject);
            uDDListenerAggregate.getNodesInsertedListener().dispose();
            uDDListenerAggregate.getNodesRemovedListener().dispose();
            this.fUDDListeners.remove(uDDObject);
        }
    }

    public UDDObject[] getPathToRoot(UDDObject uDDObject) {
        return this.getPathToRoot(uDDObject, 0);
    }

    protected UDDObject[] getPathToRoot(UDDObject uDDObject, int n) {
        UDDObject[] uDDObjectArray;
        if (uDDObject == null) {
            if (n == 0) {
                return null;
            }
            uDDObjectArray = new UDDObject[n];
        } else {
            uDDObjectArray = uDDObject == this.fRoot ? new UDDObject[n] : this.getPathToRoot((UDDObject)uDDObject.up(), ++n);
            uDDObjectArray[uDDObjectArray.length - n] = uDDObject;
        }
        return uDDObjectArray;
    }

    public Object getChild(Object object, int n) {
        UDDObject uDDObject = ((UDDObject)object).getChildAt(n);
        this.addAsListener(uDDObject);
        return uDDObject;
    }

    public int getChildCount(Object object) {
        return ((UDDObject)object).getChildCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((UDDObject)object).getIndexOfChild((UDDObject)object2);
    }

    public Object getRoot() {
        return this.fRoot;
    }

    public boolean isLeaf(Object object) {
        UDDObject uDDObject = (UDDObject)object;
        String string = uDDObject.getClassName();
        Enumeration enumeration = this.fLeafClasses.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(string2) && string.indexOf(string2) == -1) continue;
            return true;
        }
        return ((UDDObject)object).isLeaf();
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.fListenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.fListenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.fListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.fListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.fListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.fListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    class UDDListenerAggregate {
        private NodesInsertedListener nil = null;
        private NodesRemovedListener nrl = null;

        UDDListenerAggregate(NodesInsertedListener nodesInsertedListener, NodesRemovedListener nodesRemovedListener) {
            this.nil = nodesInsertedListener;
            this.nrl = nodesRemovedListener;
        }

        NodesInsertedListener getNodesInsertedListener() {
            return this.nil;
        }

        NodesRemovedListener getNodesRemovedListener() {
            return this.nrl;
        }
    }

    class NodesRemovedListener
    extends UDDListener {
        private boolean fCreatedFromEventDispatchThread;

        public NodesRemovedListener(UDDObject uDDObject) {
            super(uDDObject, "ObjectChildRemoved");
            this.fCreatedFromEventDispatchThread = false;
            this.fCreatedFromEventDispatchThread = SwingUtilities.isEventDispatchThread();
        }

        public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            final UDDObject uDDObject3 = (UDDObject)uDDObject2.getPropertyValue("Source");
            UDDObject uDDObject4 = (UDDObject)uDDObject2.getPropertyValue("Child");
            final int[] nArray = new int[1];
            final Object[] objectArray = new Object[1];
            uDDObject3.updateChildCount();
            UDDObjectTreeModel.this.updateChildIndices(uDDObject3);
            nArray[0] = uDDObject4.getIndex();
            objectArray[0] = uDDObject4;
            uDDObject3.setDirtyFlag();
            UDDObjectTreeModel.this.removeAsListener(uDDObject4);
            Runnable runnable = new Runnable(){

                public void run() {
                    UDDObjectTreeModel.this.nodesWereRemoved(uDDObject3, nArray, objectArray);
                }
            };
            if (this.fCreatedFromEventDispatchThread) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }

    class NodesInsertedListener
    extends UDDListener {
        private boolean fCreatedFromEventDispatchThread;

        public NodesInsertedListener(UDDObject uDDObject) {
            super(uDDObject, "ObjectChildAdded");
            this.fCreatedFromEventDispatchThread = false;
            this.fCreatedFromEventDispatchThread = SwingUtilities.isEventDispatchThread();
        }

        public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            final UDDObject uDDObject3 = (UDDObject)uDDObject2.getPropertyValue("Source");
            UDDObject uDDObject4 = (UDDObject)uDDObject2.getPropertyValue("Child");
            final int[] nArray = new int[1];
            final Object[] objectArray = new Object[1];
            uDDObject3.updateChildCount();
            UDDObjectTreeModel.this.updateChildIndices(uDDObject3);
            nArray[0] = uDDObject4.getIndex();
            objectArray[0] = uDDObject4;
            UDDObjectTreeModel.this.addAsListener(uDDObject4);
            Runnable runnable = new Runnable(){

                public void run() {
                    UDDObjectTreeModel.this.nodesWereInserted(uDDObject3, nArray, objectArray);
                }
            };
            if (this.fCreatedFromEventDispatchThread) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

