/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.bean.attribute_info;
import com.mathworks.jmi.bean.cp_info;
import com.mathworks.jmi.bean.exception_table_info;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class code_attribute_info
extends attribute_info
implements Cloneable {
    public int max_stack;
    public int max_locals;
    public int code_length;
    public byte[] code;
    public int exception_table_length;
    public exception_table_info[] exception_table;
    public int attributes_count;
    public attribute_info[] attributes;

    public code_attribute_info() {
    }

    public code_attribute_info(byte[] byArray, int n, int n2) {
        this.attribute_length = 8 + byArray.length + 2 + 2;
        this.max_stack = n2;
        this.max_locals = n;
        this.code_length = byArray.length;
        this.code = new byte[this.code_length];
        System.arraycopy(byArray, 0, this.code, 0, this.code_length);
        this.exception_table_length = 0;
        this.exception_table = null;
        this.attributes_count = 0;
        this.attributes = null;
    }

    public Object clone() throws CloneNotSupportedException {
        int n;
        code_attribute_info code_attribute_info2 = (code_attribute_info)super.clone();
        code_attribute_info2.exception_table = new exception_table_info[this.exception_table_length];
        for (n = 0; n < this.exception_table_length; ++n) {
            code_attribute_info2.exception_table[n] = (exception_table_info)this.exception_table[n].clone();
        }
        for (n = 0; n < this.attributes_count; ++n) {
            code_attribute_info2.attributes[n] = (attribute_info)this.attributes[n].clone();
        }
        return code_attribute_info2;
    }

    public void readValues(cp_info[] cp_infoArray, RandomAccessFile randomAccessFile) throws IOException {
        int n;
        this.max_stack = randomAccessFile.readUnsignedShort();
        this.max_locals = randomAccessFile.readUnsignedShort();
        this.code_length = randomAccessFile.readInt();
        this.code = new byte[this.code_length];
        randomAccessFile.readFully(this.code);
        this.exception_table_length = randomAccessFile.readUnsignedShort();
        this.exception_table = new exception_table_info[this.exception_table_length];
        for (n = 0; n < this.exception_table_length; ++n) {
            this.exception_table[n] = new exception_table_info();
            this.exception_table[n].readValues(randomAccessFile);
        }
        this.attributes_count = randomAccessFile.readUnsignedShort();
        this.attributes = new attribute_info[this.attributes_count];
        for (n = 0; n < this.attributes_count; ++n) {
            this.attributes[n] = attribute_info.getAttributeInfo(cp_infoArray, randomAccessFile);
        }
    }

    public void writeValues(DataOutputStream dataOutputStream) throws IOException {
        int n;
        super.writeValues(dataOutputStream);
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.code_length);
        dataOutputStream.write(this.code);
        dataOutputStream.writeShort(this.exception_table_length);
        for (n = 0; n < this.exception_table_length; ++n) {
            this.exception_table[n].writeValues(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes_count);
        for (n = 0; n < this.attributes_count; ++n) {
            this.attributes[n].writeValues(dataOutputStream);
        }
    }

    public void displayInfo(cp_info[] cp_infoArray) {
        int n;
        String string = "";
        for (n = 0; n < this.code_length; ++n) {
            string = string + Integer.toHexString((char)this.code[n] & 0xFF) + " ";
        }
        System.out.println("        Code: " + string);
        string = "";
        for (n = 0; n < this.exception_table_length; ++n) {
            string = string + this.exception_table[n] + " ";
        }
        System.out.println("            Exceptions: " + string);
        System.out.println("            Attribute Count: " + this.attributes_count + " max stack: " + this.max_stack + " max locals: " + this.max_locals);
    }
}

