/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.bean.attribute_info;
import com.mathworks.jmi.bean.constant_class_info;
import com.mathworks.jmi.bean.constant_utf8_info;
import com.mathworks.jmi.bean.cp_info;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class exceptions_attribute_info
extends attribute_info
implements Cloneable {
    int number_of_exceptions;
    int[] exception_index_table;

    public exceptions_attribute_info() {
    }

    public exceptions_attribute_info(int[] nArray) {
        this.attribute_length = 2 + 2 * nArray.length;
        this.number_of_exceptions = nArray.length;
        this.exception_index_table = new int[this.number_of_exceptions];
        System.arraycopy(nArray, 0, this.exception_index_table, 0, this.number_of_exceptions);
    }

    public Object clone() throws CloneNotSupportedException {
        exceptions_attribute_info exceptions_attribute_info2 = (exceptions_attribute_info)super.clone();
        exceptions_attribute_info2.exception_index_table = new int[this.number_of_exceptions];
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            exceptions_attribute_info2.exception_index_table[i] = this.exception_index_table[i];
        }
        return exceptions_attribute_info2;
    }

    public void readValues(cp_info[] cp_infoArray, RandomAccessFile randomAccessFile) throws IOException {
        this.number_of_exceptions = randomAccessFile.readUnsignedShort();
        this.exception_index_table = new int[this.number_of_exceptions];
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            this.exception_index_table[i] = randomAccessFile.readUnsignedShort();
        }
    }

    public void writeValues(DataOutputStream dataOutputStream) throws IOException {
        super.writeValues(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_exceptions);
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            dataOutputStream.writeShort(this.exception_index_table[i]);
        }
    }

    public void displayInfo(cp_info[] cp_infoArray) {
        System.out.println("        ExceptionTable(" + this.attribute_length + "): " + this.number_of_exceptions);
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            String string = ((constant_utf8_info)cp_infoArray[((constant_class_info)cp_infoArray[this.exception_index_table[i]]).name_index]).name;
            System.out.println("              " + this.exception_index_table[i] + ": " + string);
        }
    }
}

