/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.cd.impl;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.component.cd.api.CDComponent;
import com.ebmwebsourcing.easyesb.component.cd.impl.CDComponentImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.AdminServiceCreationFactory;
import java.net.URI;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Service;

public class ESBCDFactoryImpl
extends ESBCoreFactoryImpl {
    private Configuration conf;

    public ESBCDFactoryImpl(String ... excludedFactories) {
        super(excludedFactories);
    }

    public Node createNode(QName name, Configuration conf) throws ESBException {
        Node node = super.createNode(name, conf);
        this.conf = conf;
        try {
            CDComponent component = (CDComponent)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent("CDEngine", CDComponentImpl.class);
            this.expose(node, component);
            AdminServiceCreationFactory adminFactory = (AdminServiceCreationFactory)this.servicesFactory.get("admin-service-factory");
            adminFactory.exposeAdminService(node);
        }
        catch (Exception e) {
            throw new ESBException((Throwable)e);
        }
        return node;
    }

    public void expose(Node node, CDComponent cdComponent) throws ESBException {
        ListenerInitialisation listenerInit = (ListenerInitialisation)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ListenerInitialisation.class);
        listenerInit.setClassName(SOAPListenerImpl.class.getName());
        listenerInit.setServerName(SoapServer.DEFAULT_NAME);
        System.out.println("CD service endpoint NAME : " + ((Service)cdComponent.getDescription().getServices().iterator().next()).getEndpoints()[0].getName());
        ClientProxyEndpoint clientEndpoint = (ClientProxyEndpoint)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName(cdComponent.getDescription().getTargetNamespace(), ((Service)cdComponent.getDescription().getServices().iterator().next()).getEndpoints()[0].getName()), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, null, new ListenerInitialisation[]{listenerInit});
        clientEndpoint.setProviderServiceName(cdComponent.getQName());
        try {
            EndpointAddress epr = ESBUtil.analyzeURI((URI)cdComponent.getReference());
            clientEndpoint.setProviderEndpointName(epr.getEndpointname());
        }
        catch (SOAException e) {
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
    }
}

