/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.deployment;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableId;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.deployment.Binding")
@Searchable(root=false)
public class Binding
extends BaseObject {
    private static final long serialVersionUID = -2499871821906718599L;
    private String id;
    private Set<BindingOperation> bindingOps;
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();
    private String name;
    private Protocol protocol;
    private ServiceInterface serviceInterface;
    private Set<ServiceSpecification> serviceSpecifications;

    public Binding() {
        this.bindingOps = new HashSet<BindingOperation>();
        this.serviceSpecifications = new HashSet<ServiceSpecification>();
    }

    public void addBindingOp(BindingOperation bindingOperation) {
        this.getBindingOps().add(bindingOperation);
        bindingOperation.setBinding(this);
    }

    public void addEndpoint(Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setBinding(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Binding)) {
            return false;
        }
        Binding castOther = (Binding)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @SearchableId
    public String getId() {
        return this.id;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="binding")
    public Set<BindingOperation> getBindingOps() {
        return this.bindingOps;
    }

    @OneToMany(mappedBy="binding")
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public String getName() {
        return this.name;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="standardId", nullable=false)
    @SearchableComponent
    public Protocol getProtocol() {
        return this.protocol;
    }

    @ManyToOne
    @JoinColumn(name="serviceIntId", nullable=false)
    @SearchableComponent
    public ServiceInterface getServiceInterface() {
        return this.serviceInterface;
    }

    @ManyToMany(mappedBy="bindings")
    public Set<ServiceSpecification> getServiceSpecifications() {
        return this.serviceSpecifications;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setBindingOps(Set<BindingOperation> bindingOps) {
        this.bindingOps = bindingOps;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setServiceInterface(ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceSpecifications(Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("protocol", (Object)this.protocol).append("serviceInterface", (Object)this.serviceInterface).append("id", (Object)this.id).append("bindingOps", this.bindingOps).append("name", (Object)this.name).toString();
    }
}

