/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.deployment;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableId;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.PartyToEndpoint;
import org.ow2.dragon.persistence.bo.technology.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.deployment.Endpoint")
@Searchable(root=false)
public class Endpoint
extends BaseObject
implements Comparable<Endpoint> {
    private static final long serialVersionUID = -2024620472026451233L;
    private Binding binding;
    private String id;
    private String name;
    private String networkAddress;
    private TechnicalService technicalService;
    private Set<PartyToEndpoint> roles;
    private Node hostNode;

    @ManyToOne
    @JoinColumn(name="nodeId")
    public Node getHostNode() {
        return this.hostNode;
    }

    public void setHostNode(Node hostNode) {
        this.hostNode = hostNode;
    }

    public void addRole(PartyToEndpoint role) {
        this.getRoles().add(role);
        role.setEndpoint(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Endpoint)) {
            return false;
        }
        Endpoint castOther = (Endpoint)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @ManyToOne
    @JoinColumn(name="bindingId", nullable=false)
    @SearchableComponent
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @SearchableId
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="endpoint")
    public Set<PartyToEndpoint> getRoles() {
        return this.roles;
    }

    @ManyToOne
    @JoinColumn(name="technicalServiceId", nullable=false)
    public TechnicalService getTechnicalService() {
        return this.technicalService;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public void setRoles(Set<PartyToEndpoint> roles) {
        this.roles = roles;
    }

    public void setTechnicalService(TechnicalService technicalService) {
        this.technicalService = technicalService;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("networkAddress", (Object)this.networkAddress).append("id", (Object)this.id).append("binding", (Object)this.binding).append("name", (Object)this.name).toString();
    }

    @Override
    public int compareTo(Endpoint other) {
        return new CompareToBuilder().append((Object)this.name, (Object)other.name).toComparison();
    }
}

