/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.deployment;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.organization.PartyToTechService;
import org.ow2.dragon.persistence.bo.service.Service;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.deployment.TechnicalService")
@Searchable
public class TechnicalService
extends BaseObject {
    private static final long serialVersionUID = 1731694441773447781L;
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();
    private String name;
    private String category;
    private String purpose;
    private String otherInformation;
    private Service service;
    private ServiceInterface serviceInterface;
    private Set<ServiceSpecification> serviceSpecifications;
    private String id;
    private Set<PartyToTechService> roles = new HashSet<PartyToTechService>();

    public TechnicalService() {
        this.serviceSpecifications = new HashSet<ServiceSpecification>();
    }

    public void addEndpoint(Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setTechnicalService(this);
    }

    public void addRole(PartyToTechService role) {
        this.getRoles().add(role);
        role.setTechnicalService(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TechnicalService)) {
            return false;
        }
        TechnicalService castOther = (TechnicalService)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @SearchableProperty
    public String getCategory() {
        return this.category;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="technicalService")
    @SearchableComponent
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @SearchableProperty
    public String getName() {
        return this.name;
    }

    @SearchableProperty
    public String getOtherInformation() {
        return this.otherInformation;
    }

    @SearchableProperty
    public String getPurpose() {
        return this.purpose;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, mappedBy="technicalService")
    @SearchableComponent
    public Set<PartyToTechService> getRoles() {
        return this.roles;
    }

    @ManyToOne
    @JoinColumn(name="serviceId", nullable=true)
    public Service getService() {
        return this.service;
    }

    @ManyToOne
    @JoinColumn(name="serviceIntId", nullable=false)
    public ServiceInterface getServiceInterface() {
        return this.serviceInterface;
    }

    @ManyToMany(mappedBy="technicalServices")
    public Set<ServiceSpecification> getServiceSpecifications() {
        return this.serviceSpecifications;
    }

    @Override
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @SearchableId
    public String getId() {
        return this.id;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOtherInformation(String otherInformation) {
        this.otherInformation = otherInformation;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setRoles(Set<PartyToTechService> roles) {
        this.roles = roles;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setServiceInterface(ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceSpecifications(Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("purpose", (Object)this.purpose).append("service", (Object)this.service).append("serviceInterface", (Object)this.serviceInterface).append("category", (Object)this.category).append("endpoints", this.endpoints).append("id", (Object)this.id).append("roles", this.roles).append("otherInformation", (Object)this.otherInformation).append("name", (Object)this.name).toString();
    }
}

