/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.organization;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Post;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.organization.OrganizationUnit")
@Inheritance(strategy=InheritanceType.JOINED)
@Searchable
public class OrganizationUnit
extends Party {
    private static final long serialVersionUID = 2669421239273081631L;
    @SearchableProperty
    private String businessDomain;
    private String[] discoveryUrls;
    private boolean isLegalEntity;
    private Set<Party> parties = new HashSet<Party>();
    private Set<Post> posts = new HashSet<Post>();
    @SearchableProperty
    private String type;

    public void addParty(Party party) {
        this.getParties().add(party);
        party.setParentOrganization(this);
    }

    public void addPost(Post post) {
        this.getPosts().add(post);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OrganizationUnit)) {
            return false;
        }
        OrganizationUnit castOther = (OrganizationUnit)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.businessDomain, (Object)castOther.businessDomain).append((Object[])this.discoveryUrls, (Object[])castOther.discoveryUrls).append((Object)this.type, (Object)castOther.type).isEquals();
    }

    public String getBusinessDomain() {
        return this.businessDomain;
    }

    public String[] getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="parentOrganization")
    public Set<Party> getParties() {
        return this.parties;
    }

    @ManyToMany
    public Set<Post> getPosts() {
        return this.posts;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.businessDomain).append((Object[])this.discoveryUrls).append((Object)this.type).toHashCode();
    }

    public boolean isLegalEntity() {
        return this.isLegalEntity;
    }

    public void removePost(Post post) {
        this.getPosts().remove(post);
    }

    public void setBusinessDomain(String businessDomain) {
        this.businessDomain = businessDomain;
    }

    public void setDiscoveryUrls(String[] discoveryUrls) {
        this.discoveryUrls = discoveryUrls;
    }

    public void setLegalEntity(boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
    }

    public void setParties(Set<Party> parties) {
        this.parties = parties;
    }

    public void setPosts(Set<Post> posts) {
        this.posts = posts;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("discoveryUrls", (Object[])this.discoveryUrls).append("type", (Object)this.type).append("isLegalEntity", this.isLegalEntity).append("businessDomain", (Object)this.businessDomain).append("posts", this.posts).append("parties", this.parties).toString();
    }
}

