/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.organization;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.RoleOfParty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.organization.Party")
@Inheritance(strategy=InheritanceType.JOINED)
@Searchable
public class Party
extends BaseObject {
    private static final long serialVersionUID = 4264025768507516327L;
    @SearchableProperty
    private String city;
    @SearchableProperty
    private String complement;
    @SearchableProperty
    private String country;
    private String emailAddress;
    private boolean isExternal;
    @SearchableProperty
    private String name;
    private OrganizationUnit parentOrganization;
    @SearchableId
    private String id;
    private String responsabilities;
    private Set<RoleOfParty> roles = new HashSet<RoleOfParty>();
    @SearchableProperty
    private String state;
    @SearchableProperty
    private String street;
    @SearchableProperty
    private String streetNumber;
    @SearchableProperty
    private String zipcode;

    public void addRole(RoleOfParty roleOfParty) {
        this.getRoles().add(roleOfParty);
        roleOfParty.setParty(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Party)) {
            return false;
        }
        Party castOther = (Party)other;
        return new EqualsBuilder().append((Object)this.city, (Object)castOther.city).append((Object)this.emailAddress, (Object)castOther.emailAddress).append((Object)this.name, (Object)castOther.name).append((Object)this.zipcode, (Object)castOther.zipcode).isEquals();
    }

    public String getCity() {
        return this.city;
    }

    public String getComplement() {
        return this.complement;
    }

    public String getCountry() {
        return this.country;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getName() {
        return this.name;
    }

    @ManyToOne
    @SearchableComponent
    public OrganizationUnit getParentOrganization() {
        return this.parentOrganization;
    }

    public String getResponsabilities() {
        return this.responsabilities;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="party")
    public Set<RoleOfParty> getRoles() {
        return this.roles;
    }

    public String getState() {
        return this.state;
    }

    public String getStreet() {
        return this.street;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.city).append((Object)this.emailAddress).append((Object)this.name).append((Object)this.zipcode).toHashCode();
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentOrganization(OrganizationUnit parentOrganization) {
        this.parentOrganization = parentOrganization;
    }

    public void setResponsabilities(String responsabilities) {
        this.responsabilities = responsabilities;
    }

    public void setRoles(Set<RoleOfParty> roles) {
        this.roles = roles;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("id", (Object)this.id).append("street", (Object)this.street).append("complement", (Object)this.complement).append("responsabilities", (Object)this.responsabilities).append("streetNumber", (Object)this.streetNumber).append("roles", this.roles).append("isExternal", this.isExternal).append("country", (Object)this.country).append("emailAddress", (Object)this.emailAddress).append("state", (Object)this.state).append("name", (Object)this.name).append("zipcode", (Object)this.zipcode).append("city", (Object)this.city).toString();
    }

    @Override
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

