/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.organization;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Post;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.organization.Person")
@Inheritance(strategy=InheritanceType.JOINED)
@Searchable
public class Person
extends Party {
    private static final long serialVersionUID = -1325593703523178955L;
    private String firstName;
    private String lastName;
    private String location;
    private String middleName;
    private String phoneNumber;
    private Set<Post> posts = new HashSet<Post>();
    private String title;

    public void addPost(Post post) {
        this.getPosts().add(post);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Person)) {
            return false;
        }
        Person castOther = (Person)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.firstName, (Object)castOther.firstName).append((Object)this.lastName, (Object)castOther.lastName).isEquals();
    }

    @SearchableProperty
    public String getFirstName() {
        return this.firstName;
    }

    @SearchableProperty
    public String getLastName() {
        return this.lastName;
    }

    public String getLocation() {
        return this.location;
    }

    @SearchableProperty
    public String getMiddleName() {
        return this.middleName;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @ManyToMany
    @SearchableComponent
    public Set<Post> getPosts() {
        return this.posts;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.firstName).append((Object)this.lastName).toHashCode();
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setPosts(Set<Post> posts) {
        this.posts = posts;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("title", (Object)this.title).append("posts", this.posts).append("phoneNumber", (Object)this.phoneNumber).append("middleName", (Object)this.middleName).append("location", (Object)this.location).append("firstName", (Object)this.firstName).append("lastName", (Object)this.lastName).toString();
    }
}

