/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.service;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.service.ProposedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.service.Service")
public class Service
extends BaseObject {
    private static final long serialVersionUID = 6423683917036741837L;
    private Set<String> alias;
    private Set<String> criticalSuccessFactors;
    private String infoProcessingStyle;
    private String intendedImplementationStyle;
    private XfaceStyle interfaceStyle;
    private boolean isBusinessService;
    private String name;
    private Set<String> nonFunctionalRqmts;
    private String otherInformation;
    private Set<ProposedOperation> proposedOps;
    private String purpose;
    private String responsabilities;
    private String id;
    private String stabilityExpectations;
    private Set<String> targetCustomers;
    private Set<TechnicalService> technicalServices = new HashSet<TechnicalService>();
    private Visibility visibility;

    public Service() {
        this.proposedOps = new HashSet<ProposedOperation>();
    }

    public void addProposedOperation(ProposedOperation proposedOperation) {
        this.getProposedOps().add(proposedOperation);
        proposedOperation.setService(this);
    }

    public void addTechnicalService(TechnicalService technicalService) {
        this.getTechnicalServices().add(technicalService);
        technicalService.setService(this);
    }

    @CollectionOfElements
    public Set<String> getAlias() {
        return this.alias;
    }

    @CollectionOfElements
    public Set<String> getCriticalSuccessFactors() {
        return this.criticalSuccessFactors;
    }

    public String getInfoProcessingStyle() {
        return this.infoProcessingStyle;
    }

    public String getIntendedImplementationStyle() {
        return this.intendedImplementationStyle;
    }

    @Enumerated(value=EnumType.STRING)
    public XfaceStyle getInterfaceStyle() {
        return this.interfaceStyle;
    }

    public String getName() {
        return this.name;
    }

    @CollectionOfElements
    public Set<String> getNonFunctionalRqmts() {
        return this.nonFunctionalRqmts;
    }

    public String getOtherInformation() {
        return this.otherInformation;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="service")
    public Set<ProposedOperation> getProposedOps() {
        return this.proposedOps;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public String getResponsabilities() {
        return this.responsabilities;
    }

    @Override
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    public String getId() {
        return this.id;
    }

    public String getStabilityExpectations() {
        return this.stabilityExpectations;
    }

    @CollectionOfElements
    public Set<String> getTargetCustomers() {
        return this.targetCustomers;
    }

    @OneToMany(mappedBy="service")
    public Set<TechnicalService> getTechnicalServices() {
        return this.technicalServices;
    }

    @Enumerated(value=EnumType.STRING)
    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isBusinessService() {
        return this.isBusinessService;
    }

    public void setAlias(Set<String> alias) {
        this.alias = alias;
    }

    public void setBusinessService(boolean isBusinessService) {
        this.isBusinessService = isBusinessService;
    }

    public void setCriticalSuccessFactors(Set<String> criticalSuccessFactors) {
        this.criticalSuccessFactors = criticalSuccessFactors;
    }

    public void setInfoProcessingStyle(String infoProcessingStyle) {
        this.infoProcessingStyle = infoProcessingStyle;
    }

    public void setIntendedImplementationStyle(String intendedImplementationStyle) {
        this.intendedImplementationStyle = intendedImplementationStyle;
    }

    public void setInterfaceStyle(XfaceStyle interfaceStyle) {
        this.interfaceStyle = interfaceStyle;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNonFunctionalRqmts(Set<String> nonFunctionalRqmts) {
        this.nonFunctionalRqmts = nonFunctionalRqmts;
    }

    public void setOtherInformation(String otherInformation) {
        this.otherInformation = otherInformation;
    }

    public void setProposedOps(Set<ProposedOperation> proposedOps) {
        this.proposedOps = proposedOps;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setResponsabilities(String responsabilities) {
        this.responsabilities = responsabilities;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setStabilityExpectations(String stabilityExpectations) {
        this.stabilityExpectations = stabilityExpectations;
    }

    public void setTargetCustomers(Set<String> targetCustomers) {
        this.targetCustomers = targetCustomers;
    }

    public void setTechnicalServices(Set<TechnicalService> technicalServices) {
        this.technicalServices = technicalServices;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Service)) {
            return false;
        }
        Service castOther = (Service)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("intendedImplementationStyle", (Object)this.intendedImplementationStyle).append("visibility", (Object)this.visibility).append("interfaceStyle", (Object)this.interfaceStyle).append("id", (Object)this.id).append("isBusinessService", this.isBusinessService).append("responsabilities", (Object)this.responsabilities).append("otherInformation", (Object)this.otherInformation).append("criticalSuccessFactors", this.criticalSuccessFactors).append("proposedOps", this.proposedOps).append("targetCustomers", this.targetCustomers).append("alias", this.alias).append("purpose", (Object)this.purpose).append("infoProcessingStyle", (Object)this.infoProcessingStyle).append("technicalServices", this.technicalServices).append("stabilityExpectations", (Object)this.stabilityExpectations).append("name", (Object)this.name).append("nonFunctionalRqmts", this.nonFunctionalRqmts).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XfaceStyle {
        DIGITAL,
        DUAL,
        NONDIGITAL,
        UNDECIDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visibility {
        CUSTOMERS,
        ENTERPRISE_INTERNAL,
        ORG_UNIT_INTERNAL,
        PARTITION_INTERNAL,
        PARTNER_ORGANIZATIONS,
        PUBLIC,
        SPECIFIC_CUSTOMERS,
        SPECIFIC_PARTNERS;

    }
}

