/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.sla;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.ggf.schemas.graap._2007._03.ws_agreement.Agreement;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.organization.Party;

@Entity(name="org.ow2.dragon.persistence.bo.sla.ManagedAgreeement")
@Searchable
public class ManagedAgreement
extends BaseObject {
    private static final long serialVersionUID = -8845307971105866677L;
    private boolean isEditable;
    private AgreementState currentState;
    private Date signedByClient;
    private Date signedByProvider;
    private Agreement agreement;
    private String idFile;
    private Party client;
    private Party provider;
    protected String id;
    private String name;
    private String initiator;
    private String responder;

    public ManagedAgreement() {
    }

    public ManagedAgreement(Agreement a, boolean isEditable) {
        this.agreement = a;
        this.isEditable = isEditable;
        this.currentState = AgreementState.PENDING;
    }

    @OneToOne
    public Agreement getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Agreement a) {
        this.agreement = a;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public AgreementState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(AgreementState state) {
        this.currentState = state;
    }

    public Date getSignedByClient() {
        Date res = null;
        if (this.signedByClient != null) {
            res = (Date)this.signedByClient.clone();
        }
        return res;
    }

    public void setSignedByClient(Date signedByClient) {
        this.signedByClient = signedByClient != null ? (Date)signedByClient.clone() : null;
    }

    public Date getSignedByProvider() {
        Date res = null;
        if (this.signedByProvider != null) {
            res = (Date)this.signedByProvider.clone();
        }
        return res;
    }

    public void setSignedByProvider(Date signedByProvider) {
        this.signedByProvider = signedByProvider != null ? (Date)signedByProvider.clone() : null;
    }

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @SearchableId
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @OneToOne
    public Party getClient() {
        return this.client;
    }

    public void setClient(Party client) {
        this.client = client;
    }

    public String getIdFile() {
        return this.idFile;
    }

    public void setIdFile(String idFile) {
        this.idFile = idFile;
    }

    @OneToOne
    public Party getProvider() {
        return this.provider;
    }

    public void setProvider(Party provider) {
        this.provider = provider;
    }

    @SearchableProperty
    @Transient
    public String getName() {
        return this.agreement.getName();
    }

    @SearchableProperty
    @Transient
    public String getInitiator() {
        return this.agreement.getContext().getAgreementInitiatorObject();
    }

    @SearchableProperty
    @Transient
    public String getResponder() {
        return this.agreement.getContext().getAgreementResponderObject();
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setInitiator(String value) {
        this.initiator = value;
    }

    public void setResponder(String value) {
        this.responder = value;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ManagedAgreement)) {
            return false;
        }
        ManagedAgreement castOther = (ManagedAgreement)other;
        return new EqualsBuilder().append((Object)this.currentState, (Object)castOther.currentState).append((Object)this.getName(), (Object)castOther.getName()).append((Object)this.getInitiator(), (Object)castOther.getInitiator()).append((Object)this.getResponder(), (Object)castOther.getResponder()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.currentState).append((Object)this.getName()).append((Object)this.getInitiator()).append((Object)this.getResponder()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("currentState", (Object)this.currentState).append("isEditable", this.isEditable).append("idFile", (Object)this.idFile).append("signedByProvider", (Object)this.signedByProvider).append("signedByClient", (Object)this.signedByClient).append("provider", (Object)this.provider).append("client", (Object)this.client).append("id", (Object)this.id).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgreementState {
        UNKNOWN,
        PENDING,
        PENDING_AND_TERMINATING,
        OBSERVED,
        OBSERVED_AND_TERMINTATING,
        REJECTED,
        COMPLETE,
        TERMINTATED;

    }
}

