/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableId;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.specification.ServiceInterface")
@Searchable(root=false)
public class ServiceInterface
extends BaseObject {
    private static final long serialVersionUID = 4970986248323341443L;
    private Set<Binding> bindings;
    private String name;
    private String id;
    private Set<ServiceSpecification> serviceSpecs;
    private Set<SpecifiedOperation> specifiedOps;
    private Set<TechnicalService> technicalServices = new HashSet<TechnicalService>();

    public ServiceInterface() {
        this.specifiedOps = new HashSet<SpecifiedOperation>();
        this.bindings = new HashSet<Binding>();
        this.serviceSpecs = new HashSet<ServiceSpecification>();
    }

    public void addBinding(Binding binding) {
        this.getBindings().add(binding);
        binding.setServiceInterface(this);
    }

    public void addSpecifiedOp(SpecifiedOperation specifiedOperation) {
        this.getSpecifiedOps().add(specifiedOperation);
        specifiedOperation.setServiceInterface(this);
    }

    public void addTechnicalService(TechnicalService technicalService) {
        this.getTechnicalServices().add(technicalService);
        technicalService.setServiceInterface(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ServiceInterface)) {
            return false;
        }
        ServiceInterface castOther = (ServiceInterface)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @OneToMany(mappedBy="serviceInterface")
    public Set<Binding> getBindings() {
        return this.bindings;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @SearchableId
    public String getId() {
        return this.id;
    }

    @ManyToMany(mappedBy="serviceInterfaces")
    public Set<ServiceSpecification> getServiceSpecs() {
        return this.serviceSpecs;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="serviceInterface")
    @SearchableComponent
    public Set<SpecifiedOperation> getSpecifiedOps() {
        return this.specifiedOps;
    }

    @OneToMany(mappedBy="serviceInterface")
    public Set<TechnicalService> getTechnicalServices() {
        return this.technicalServices;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    public void setBindings(Set<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setServiceSpecs(Set<ServiceSpecification> serviceSpecs) {
        this.serviceSpecs = serviceSpecs;
    }

    public void setSpecifiedOps(Set<SpecifiedOperation> specifiedOps) {
        this.specifiedOps = specifiedOps;
    }

    public void setTechnicalServices(Set<TechnicalService> technicalServices) {
        this.technicalServices = technicalServices;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("specifiedOps", this.specifiedOps).append("id", (Object)this.id).append("name", (Object)this.name).toString();
    }
}

