/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.specification.ServiceDefinitionLanguageFile;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.VersionedSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.specification.ServiceSpecification")
@Inheritance(strategy=InheritanceType.JOINED)
public class ServiceSpecification
extends VersionedSpecification {
    private static final long serialVersionUID = -720509434728670906L;
    private Set<Binding> bindings;
    private String estimatedUsage;
    private boolean hasRuntimeInstancies;
    private String otherSpecInformation;
    private ServiceDefinitionLanguageFile serviceDefLangFile;
    private Set<ServiceInterface> serviceInterfaces = new HashSet<ServiceInterface>();
    private Set<TechnicalService> technicalServices = new HashSet<TechnicalService>();

    public ServiceSpecification() {
        this.bindings = new HashSet<Binding>();
    }

    public void addBinding(Binding binding) {
        this.getBindings().add(binding);
        binding.getServiceSpecifications().add(this);
    }

    public void addServiceInterface(ServiceInterface serviceInterface) {
        this.getServiceInterfaces().add(serviceInterface);
        serviceInterface.getServiceSpecs().add(this);
    }

    public void addTechnicalService(TechnicalService technicalService) {
        this.getTechnicalServices().add(technicalService);
        technicalService.getServiceSpecifications().add(this);
    }

    @ManyToMany
    public Set<Binding> getBindings() {
        return this.bindings;
    }

    public String getEstimatedUsage() {
        return this.estimatedUsage;
    }

    public String getOtherSpecInformation() {
        return this.otherSpecInformation;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="serviceDefId", nullable=true)
    public ServiceDefinitionLanguageFile getServiceDefLangFile() {
        return this.serviceDefLangFile;
    }

    @ManyToMany
    public Set<ServiceInterface> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    @ManyToMany
    public Set<TechnicalService> getTechnicalServices() {
        return this.technicalServices;
    }

    public boolean isHasRuntimeInstancies() {
        return this.hasRuntimeInstancies;
    }

    public void setBindings(Set<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setEstimatedUsage(String estimatedUsage) {
        this.estimatedUsage = estimatedUsage;
    }

    public void setHasRuntimeInstancies(boolean hasRuntimeInstancies) {
        this.hasRuntimeInstancies = hasRuntimeInstancies;
    }

    public void setOtherSpecInformation(String otherSpecInformation) {
        this.otherSpecInformation = otherSpecInformation;
    }

    public void setServiceDefLangFile(ServiceDefinitionLanguageFile serviceDefLangFile) {
        this.serviceDefLangFile = serviceDefLangFile;
    }

    public void setServiceInterfaces(Set<ServiceInterface> serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public void setTechnicalServices(Set<TechnicalService> technicalServices) {
        this.technicalServices = technicalServices;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("estimatedUsage", (Object)this.estimatedUsage).append("bindings", this.bindings).append("hasRuntimeInstancies", this.hasRuntimeInstancies).append("serviceInterfaces", this.serviceInterfaces).append("serviceDefLangFile", (Object)this.serviceDefLangFile).append("technicalServices", this.technicalServices).append("otherSpecInformation", (Object)this.otherSpecInformation).toString();
    }
}

