/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.technology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableId;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.GenericGenerator;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.technology.EnvironmentFederation")
@Searchable
public class EnvironmentFederation
extends BaseObject {
    private static final long serialVersionUID = 357424309465096843L;
    private String id;
    private String name;
    private FedPattern pattern;
    private List<String> possibleRole;
    private Set<ExecutionEnvironment> execEnvs = new HashSet<ExecutionEnvironment>();

    public EnvironmentFederation() {
        this.possibleRole = new ArrayList<String>();
    }

    public void addExecEnv(ExecutionEnvironment executionEnvironment) {
        this.execEnvs.add(executionEnvironment);
        executionEnvironment.setParentFederation(this);
    }

    public void addPossibleRole(String possibleRole) {
        this.possibleRole.add(possibleRole);
    }

    public void removeExecEnv(ExecutionEnvironment executionEnvironment) {
        this.getExecEnvs().remove(executionEnvironment);
        executionEnvironment.setParentFederation(null);
    }

    @OneToMany(mappedBy="parentFederation")
    public Set<ExecutionEnvironment> getExecEnvs() {
        return this.execEnvs;
    }

    public void setExecEnvs(Set<ExecutionEnvironment> execEnvs) {
        this.execEnvs = execEnvs;
    }

    @Override
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @SearchableId
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @SearchableProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Enumerated(value=EnumType.STRING)
    @SearchableProperty
    public FedPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(FedPattern pattern) {
        this.pattern = pattern;
    }

    @CollectionOfElements
    public List<String> getPossibleRole() {
        return this.possibleRole;
    }

    public void setPossibleRole(List<String> possibleRole) {
        this.possibleRole = possibleRole;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof EnvironmentFederation)) {
            return false;
        }
        EnvironmentFederation castOther = (EnvironmentFederation)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("execEnvs", this.execEnvs).append("pattern", (Object)this.pattern).append("possibleRole", this.possibleRole).append("name", (Object)this.name).append("id", (Object)this.id).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FedPattern {
        HUB_AND_SPOKE,
        FEDERATED,
        GRID,
        DISTRIBUTED;

    }
}

