/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ow2.dragon.persistence.bo.BaseObject;
import org.ow2.dragon.persistence.dao.GenericORMDAO;
import org.ow2.dragon.persistence.dao.GenericOSEMDAO;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.util.OSEMQueryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericHibernateCompassDAOImpl<T extends BaseObject, PK extends Serializable>
implements GenericUnifiedDAO<T, PK> {
    private GenericOSEMDAO<T, PK> genericOSEMDAO;
    private GenericORMDAO<T, PK> genericORMDAO;

    @Override
    public boolean exists(PK id) {
        return this.genericORMDAO.exists(id);
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        return this.genericORMDAO.findByNamedQuery(queryName, queryParams);
    }

    @Override
    public T get(PK id) {
        return (T)((BaseObject)this.genericORMDAO.get(id));
    }

    @Override
    public List<T> getAll(RequestOptions requestOptionsTO) {
        return this.genericORMDAO.getAll(requestOptionsTO);
    }

    @Override
    public List<T> getAll() {
        return this.genericORMDAO.getAll();
    }

    @Override
    public List<T> getAllDistinct() {
        return this.genericORMDAO.getAllDistinct();
    }

    @Override
    public void remove(PK id) {
        this.genericORMDAO.remove(id);
    }

    @Override
    public T save(T object) {
        return (T)((BaseObject)this.genericORMDAO.save(object));
    }

    @Override
    public List<T> search(String query) {
        return this.genericOSEMDAO.search(query);
    }

    @Override
    public List<T> searchEquals(String[] criteria, String[] properties, RequestOptions requestOptionsTO) {
        return this.genericORMDAO.searchEquals(criteria, properties, requestOptionsTO);
    }

    @Override
    public List<T> searchLike(String[] criteria, String[] properties, RequestOptions requestOptionsTO) {
        return this.genericORMDAO.searchLike(criteria, properties, requestOptionsTO);
    }

    @Override
    public List<T> searchORMResult(String query) {
        return this.searchORMResult(query, null);
    }

    @Override
    public List<T> searchORMResult(String query, RequestOptions requestOptions) {
        List<T> osemResults = this.search(query);
        ArrayList<String> ids = new ArrayList<String>();
        for (BaseObject t : osemResults) {
            ids.add(t.getId());
        }
        return this.getAll(ids, requestOptions);
    }

    @Override
    public List<T> getAll(List<PK> ids, RequestOptions requestOptions) {
        return this.genericORMDAO.getAll(ids, requestOptions);
    }

    @Override
    public List<T> getAll(List<PK> ids) {
        return this.getAll(ids, null);
    }

    @Override
    public List<T> searchORMResult(String[] criteria, String[] searchedProperties) {
        return this.searchORMResult(criteria, searchedProperties, null);
    }

    @Override
    public List<T> searchORMResult(String[] criteria, String[] searchedProperties, RequestOptions requestOptions) {
        String query = OSEMQueryHelper.decorateQuery(criteria, searchedProperties, this.genericOSEMDAO.getManipulatedType().getSimpleName());
        return this.searchORMResult(query, requestOptions);
    }

    public void setGenericOSEMDAO(GenericOSEMDAO<T, PK> genericOSEMDAO) {
        this.genericOSEMDAO = genericOSEMDAO;
    }

    public void setGenericORMDAO(GenericORMDAO<T, PK> genericORMDAO) {
        this.genericORMDAO = genericORMDAO;
    }
}

