/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.criterion.DetachedCriteria;
import org.ow2.dragon.persistence.dao.GenericORMDAO;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.util.ORMQueryHelper;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericHibernateDAOImpl<T, PK extends Serializable>
extends HibernateDaoSupport
implements GenericORMDAO<T, PK> {
    private Logger log = Logger.getLogger(this.getClass());
    public Class<T> type;

    public void setType(Class<T> type) {
        this.type = type;
    }

    @Override
    public List<T> getAll(RequestOptions requestOptions) {
        List result = new ArrayList();
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.type);
        result = ORMQueryHelper.sortAndPaginateByCriteria(this.getHibernateTemplate(), requestOptions, detachedCriteria);
        return result;
    }

    private List<T> search(String[] criteria, String[] properties, RequestOptions requestOptions, String statementType) {
        StringBuffer queryString = new StringBuffer();
        String simpleClazzName = this.type.getSimpleName();
        String fullClazzName = this.type.getCanonicalName();
        ORMQueryHelper.addSelectDistinctStatement(queryString, simpleClazzName, fullClazzName);
        Query query = null;
        if (criteria != null && properties != null && criteria.length > 0 && properties.length > 0) {
            ORMQueryHelper.addJoinStatement(properties, queryString, simpleClazzName.toLowerCase());
            boolean caseSensitive = requestOptions != null ? requestOptions.isCaseSensitive() : false;
            ORMQueryHelper.addSearchCriteriaInQuery(criteria, properties, queryString, simpleClazzName.toLowerCase(), statementType, caseSensitive);
            query = ORMQueryHelper.sortAndPaginateByQuery(this.getSession(), requestOptions, queryString, simpleClazzName.toLowerCase());
            ORMQueryHelper.fillPlaceHolder(criteria, query, statementType, caseSensitive);
        } else {
            query = ORMQueryHelper.sortAndPaginateByQuery(this.getSession(), requestOptions, queryString, simpleClazzName.toLowerCase());
        }
        this.log.debug((Object)("Hibernate Query: " + query));
        return query.list();
    }

    @Override
    public List<T> searchEquals(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "equals");
    }

    @Override
    public List<T> searchLike(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "like");
    }

    @Override
    public List<T> getAll() {
        return super.getHibernateTemplate().loadAll(this.type);
    }

    @Override
    public List<T> getAll(List<PK> ids) {
        return this.getAll(ids, null);
    }

    @Override
    public List<T> getAll(List<PK> ids, RequestOptions requestOptions) {
        List result = new ArrayList();
        if (ids != null && !ids.isEmpty()) {
            StringBuffer queryBuffer = new StringBuffer("");
            String simpleTypeName = this.type.getSimpleName();
            String fullTypeName = this.type.getName();
            StringBuffer idsTable = new StringBuffer("");
            for (Serializable pk : ids) {
                if (pk instanceof String) {
                    idsTable.append("'").append(pk).append("'").append(",");
                    continue;
                }
                idsTable.append(pk).append(",");
            }
            queryBuffer.append("select ").append(simpleTypeName).append(" from ").append(fullTypeName).append(" ").append(simpleTypeName).append(" ");
            queryBuffer.append("where " + simpleTypeName + ".id in (").append(idsTable.substring(0, idsTable.length() - 1)).append(")");
            Query query = ORMQueryHelper.sortAndPaginateByQuery(this.getSession(), requestOptions, queryBuffer, simpleTypeName);
            this.log.debug((Object)("Hibernate Query: " + query));
            result = query.list();
        }
        return result;
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public T get(PK id) {
        Object entity = super.getHibernateTemplate().get(this.type, id);
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Object entity = super.getHibernateTemplate().get(this.type, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        super.getHibernateTemplate().saveOrUpdate(object);
        return object;
    }

    @Override
    public void remove(PK id) {
        super.getHibernateTemplate().delete(this.get(id));
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        String[] params = new String[queryParams.size()];
        Object[] values = new Object[queryParams.size()];
        int index = 0;
        Iterator<String> i = queryParams.keySet().iterator();
        while (i.hasNext()) {
            String key;
            params[index] = key = i.next();
            values[index++] = queryParams.get(key);
        }
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, params, values);
    }

    @Override
    public Class<T> getManipulatedType() {
        return this.type;
    }
}

