/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.criterion.DetachedCriteria;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.dao.UniversalORMDAO;
import org.ow2.dragon.persistence.util.ORMQueryHelper;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class UniversalHibernateDAOImpl
extends HibernateDaoSupport
implements UniversalORMDAO {
    private Logger log = Logger.getLogger(this.getClass());

    public Object save(Object o) {
        this.getHibernateTemplate().saveOrUpdate(o);
        return o;
    }

    public Object get(Class clazz, Serializable id) {
        Object o = this.getHibernateTemplate().get(clazz, id);
        if (o == null) {
            throw new ObjectRetrievalFailureException(clazz, (Object)id);
        }
        return o;
    }

    public List getAll(Class clazz) {
        return this.getHibernateTemplate().loadAll(clazz);
    }

    public void remove(Class clazz, Serializable id) {
        this.getHibernateTemplate().delete(this.get(clazz, id));
    }

    public List getAll(Class clazz, List ids) {
        return this.getAll(clazz, ids, null);
    }

    public List getAll(Class clazz, List ids, RequestOptions requestOptions) {
        List result = new ArrayList();
        if (ids != null && !ids.isEmpty()) {
            StringBuffer queryBuffer = new StringBuffer("");
            String simpleTypeName = clazz.getSimpleName();
            String fullTypeName = clazz.getName();
            StringBuffer idsTable = new StringBuffer("");
            for (Object pk : ids) {
                if (pk instanceof String) {
                    idsTable.append("'").append(pk).append("'").append(",");
                    continue;
                }
                idsTable.append(pk).append(",");
            }
            queryBuffer.append("select ").append(simpleTypeName).append(" from ").append(fullTypeName).append(" ").append(simpleTypeName).append(" ");
            queryBuffer.append("where " + simpleTypeName + ".id in (").append(idsTable.substring(0, idsTable.length() - 1)).append(")");
            Query query = ORMQueryHelper.sortAndPaginateByQuery(this.getSession(), requestOptions, queryBuffer, simpleTypeName);
            this.log.debug((Object)("Hibernate Query: " + query));
            result = query.list();
        }
        return result;
    }

    public List getAll(Class clazz, RequestOptions requestOptions) {
        List result = new ArrayList();
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass((Class)clazz);
        result = ORMQueryHelper.sortAndPaginateByCriteria(this.getHibernateTemplate(), requestOptions, detachedCriteria);
        return result;
    }

    public List searchEquals(Class clazz, String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(clazz, criteria, properties, requestOptions, "equals");
    }

    public List searchLike(Class clazz, String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(clazz, criteria, properties, requestOptions, "like");
    }

    private List search(Class clazz, String[] criteria, String[] properties, RequestOptions requestOptions, String statementType) {
        StringBuffer queryString = new StringBuffer();
        String simpleClazzName = clazz.getSimpleName();
        String fullClazzName = clazz.getCanonicalName();
        ORMQueryHelper.addSelectDistinctStatement(queryString, simpleClazzName, fullClazzName);
        Query query = null;
        if (criteria != null && properties != null && criteria.length > 0 && properties.length > 0) {
            ORMQueryHelper.addJoinStatement(properties, queryString, simpleClazzName.toLowerCase());
            boolean caseSensitive = requestOptions != null ? requestOptions.isCaseSensitive() : false;
            ORMQueryHelper.addSearchCriteriaInQuery(criteria, properties, queryString, simpleClazzName.toLowerCase(), statementType, caseSensitive);
            query = ORMQueryHelper.sortAndPaginateByQuery(this.getSession(), requestOptions, queryString, simpleClazzName.toLowerCase());
            ORMQueryHelper.fillPlaceHolder(criteria, query, statementType, caseSensitive);
        } else {
            query = ORMQueryHelper.sortAndPaginateByQuery(this.getSession(), requestOptions, queryString, simpleClazzName.toLowerCase());
        }
        this.log.debug((Object)("Hibernate Query: " + query));
        return query.list();
    }
}

