/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.util;

import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class ORMQueryHelper {
    public static final String EQUALS_STATEMENT = "equals";
    public static final String LIKE_STATEMENT = "like";

    public static void addCriteriaPlaceHolder(StringBuffer queryString, int i) {
        queryString.append(":c").append(i);
    }

    public static void addInnerJoinStatement(StringBuffer queryString, String clazzAlias, String fieldName) {
        queryString.append(" inner join ").append(clazzAlias).append(".").append(fieldName).append(" ").append(fieldName).append(" ");
    }

    public static void addJoinStatement(String[] properties, StringBuffer queryString, String clazzAlias) {
        for (String property : properties) {
            if (!property.contains(".")) continue;
            String[] propSplit = property.split("\\.");
            String fieldName = propSplit[0];
            ORMQueryHelper.addInnerJoinStatement(queryString, clazzAlias, fieldName);
            for (int i = 1; i < propSplit.length - 1; ++i) {
                ORMQueryHelper.addInnerJoinStatement(queryString, propSplit[i - 1], propSplit[i]);
            }
        }
    }

    public static void addSearchCriteriaInQuery(String[] criteria, String[] properties, StringBuffer queryString, String clazzAlias, String statementType, boolean caseSensitive) {
        queryString.append(" where ");
        for (int i = 0; i < criteria.length; ++i) {
            queryString.append("(");
            for (String p : properties) {
                if (!caseSensitive) {
                    queryString.append("LOWER(");
                }
                ORMQueryHelper.addSearchedProperty(queryString, clazzAlias, p);
                if (!caseSensitive) {
                    queryString.append(") ");
                }
                ORMQueryHelper.addStatementType(queryString, statementType);
                queryString.append(" ");
                ORMQueryHelper.addCriteriaPlaceHolder(queryString, i);
                queryString.append(" or ");
            }
            queryString.delete(queryString.length() - 4, queryString.length()).append(") and ");
        }
        queryString.delete(queryString.length() - 4, queryString.length());
    }

    public static void addSearchedProperty(StringBuffer queryString, String clazzAlias, String p) {
        if (!p.contains(".")) {
            queryString.append(clazzAlias).append(".").append(p);
        } else {
            String[] pSplit = p.split("\\.");
            int length = pSplit.length;
            queryString.append(pSplit[length - 2]).append(".").append(pSplit[length - 1]);
        }
    }

    public static void addSelectDistinctStatement(StringBuffer queryString, String simpleClazzName, String fullClazzName) {
        queryString.append("select distinct ").append(simpleClazzName.toLowerCase()).append(" from ").append(fullClazzName).append(" ").append(simpleClazzName.toLowerCase()).append(" ");
    }

    public static void addStatementType(StringBuffer queryString, String statementType) {
        if (LIKE_STATEMENT.equals(statementType)) {
            queryString.append(LIKE_STATEMENT);
        } else if (EQUALS_STATEMENT.equals(statementType)) {
            queryString.append("=");
        }
    }

    public static void fillPlaceHolder(String[] criteria, Query query, String statementType, boolean caseSensitive) {
        if (criteria != null && criteria.length > 0) {
            for (int i = 0; i < criteria.length; ++i) {
                if (statementType.equals(LIKE_STATEMENT)) {
                    query.setString("c" + i, "%" + (caseSensitive ? criteria[i] : criteria[i].toLowerCase()) + "%");
                    continue;
                }
                query.setString("c" + i, caseSensitive ? criteria[i] : criteria[i].toLowerCase());
            }
        }
    }

    public static Query sortAndPaginateByQuery(Session session, RequestOptions requestOptions, StringBuffer queryString, String clazzAlias) {
        Query result;
        if (requestOptions != null) {
            if (requestOptions.hasSortOption()) {
                queryString.append(" order by ").append(clazzAlias).append(".").append(requestOptions.getSortCriteria());
                if (requestOptions.isSortAscendingly()) {
                    queryString.append(" asc ");
                } else {
                    queryString.append(" desc ");
                }
            }
            result = session.createQuery(queryString.toString());
            if (requestOptions.hasPagination()) {
                result.setFirstResult(requestOptions.getFirstResult());
                result.setMaxResults(requestOptions.getNbOfResults());
            }
        } else {
            result = session.createQuery(queryString.toString());
        }
        return result;
    }

    public static List sortAndPaginateByCriteria(HibernateTemplate template, RequestOptions requestOptions, DetachedCriteria detachedCriteria) {
        List result;
        if (requestOptions != null) {
            if (requestOptions.hasSortOption()) {
                if (requestOptions.isSortAscendingly()) {
                    detachedCriteria.addOrder(Order.asc((String)requestOptions.getSortCriteria()));
                } else {
                    detachedCriteria.addOrder(Order.desc((String)requestOptions.getSortCriteria()));
                }
            }
            result = requestOptions.hasPagination() ? template.findByCriteria(detachedCriteria, requestOptions.getFirstResult(), requestOptions.getNbOfResults()) : template.findByCriteria(detachedCriteria);
        } else {
            result = template.findByCriteria(detachedCriteria);
        }
        return result;
    }
}

