/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui;

import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.administration.RoleGroupManager;
import org.ow2.dragon.api.service.administration.RoleManager;
import org.ow2.dragon.api.service.administration.UserManager;
import org.ow2.dragon.api.service.dataloader.DataLoaderException;
import org.ow2.dragon.service.uddi.v3.util.UDDIObjectFactory;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.SpringUtil;
import org.ow2.opensuit.core.impl.j2ee.OpenSuitServlet;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.uddi.api_v3.SaveTModel;

public class DragonServlet
extends OpenSuitServlet {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = 7866098412536374367L;

    public void init() throws ServletException {
        super.init();
        this.setDefaultTransformerFactory();
        this.initTModels();
        this.initRoles();
        this.initRoleGroup();
        this.initUser();
        this.initDragonDatabase();
    }

    private void setDefaultTransformerFactory() {
        String dftClazzName = this.getInitParameter("defaultTransformerFactory");
        System.setProperty("javax.xml.transform.TransformerFactory", dftClazzName);
    }

    private void initRoles() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            this.logger.info((Object)"Init base roles");
            WebApplicationContext applicationContext = SpringUtil.getWebApplicationContext((ServletContext)servletContext);
            RoleManager roleManager = (RoleManager)applicationContext.getBean("roleManager");
            roleManager.init();
        }
    }

    private void initRoleGroup() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            this.logger.info((Object)"Init base role groups");
            WebApplicationContext applicationContext = SpringUtil.getWebApplicationContext((ServletContext)servletContext);
            RoleGroupManager roleGroupManager = (RoleGroupManager)applicationContext.getBean("roleGroupManager");
            roleGroupManager.init();
        }
    }

    private void initUser() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            this.logger.info((Object)"Init users");
            WebApplicationContext applicationContext = SpringUtil.getWebApplicationContext((ServletContext)servletContext);
            UserManager userManager = (UserManager)applicationContext.getBean("userManager");
            userManager.init();
        }
    }

    private void initDragonDatabase() {
        String datasetLocation = this.getInitParameter("datasetLocation");
        try {
            if (StringUtils.hasText((String)datasetLocation)) {
                this.logger.info((Object)"Create Dragon Database");
                DragonServiceFactory.getInstance((ServletContext)this.getServletContext()).getDataLoader().loadDataSet(datasetLocation);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Can't load Dragon dataset from location: " + datasetLocation));
            this.logger.debug((Object)("Can't load Dragon dataset from location: " + datasetLocation), (Throwable)e);
        }
    }

    private void initTModels() {
        block4: {
            this.logger.info((Object)"Load base TModels");
            String tModelsLocation = this.getInitParameter("baseTModelsLocation");
            try {
                InputStream tModelsStream;
                if (!StringUtils.hasText((String)tModelsLocation)) break block4;
                try {
                    tModelsStream = InputStreamUtil.getInputStream((String)tModelsLocation);
                }
                catch (Exception e) {
                    throw new DataLoaderException("Can't load TModels xml file", (Throwable)e);
                }
                SaveTModel saveTModel = UDDIObjectFactory.getInstance().convertStreamSource2SaveTModel((Source)new StreamSource(tModelsStream));
                DragonServiceFactory.getInstance((ServletContext)this.getServletContext()).getUDDIPublicationService().saveTModel(saveTModel);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Can't load TModels from location: " + tModelsLocation));
                this.logger.debug((Object)("Can't load TModels from location: " + tModelsLocation), (Throwable)e);
            }
        }
    }
}

