/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceFactory;
import org.ow2.dragon.util.InputStreamUtil;

public class RepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 3069362997017015761L;
    private Logger logger = Logger.getLogger(this.getClass());
    private MetadataService metadataService;

    public void init() throws ServletException {
        try {
            this.metadataService = DragonServiceFactory.getInstance((ServletContext)this.getServletContext()).getMetadataService();
        }
        catch (DragonDelegateException e) {
            throw new ServletException((Throwable)e);
        }
        boolean cleanup = Boolean.parseBoolean(this.getInitParameter("cleanup"));
        if (cleanup) {
            this.logger.info((Object)"Cleanup file repository");
            this.metadataService.cleanupRepository();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String fileId = req.getParameter("fileId");
        SimpleFile simpleFile = this.metadataService.loadMetadata(fileId);
        InputStream input = null;
        try {
            input = this.metadataService.loadMetadataContentAsInputStream(fileId);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        ServletOutputStream output = resp.getOutputStream();
        resp.setContentType(simpleFile.getFileType().toString());
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        InputStreamUtil.copy((InputStream)input, (OutputStream)output);
        input.close();
        output.close();
    }
}

