/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.bricks;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.expression.ExpressionUtils;
import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.opensuit.xml.base.binding.Expression;
import org.ow2.opensuit.xml.base.html.IView;
import org.ow2.opensuit.xmlmap.annotations.XmlAttribute;
import org.ow2.opensuit.xmlmap.annotations.XmlChild;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

@XmlDoc(value="The menu that summarizes the user identity.")
@XmlElement
public class LoggedMenu
implements IView,
IInitializable {
    @XmlAttribute(name="CssClass", required=false)
    private String cssClass = "Logged";
    @XmlChild(name="Visible", required=false)
    private Expression visible;
    @XmlChild(name="LoggedTitle")
    private Expression loggedTitle;
    @XmlChild(name="LogoutTitle")
    private Expression logoutTitle;

    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        ExpressionUtils.validateBooleanExpr((IInitializationSupport)initSupport, (Object)instContext, (Object)this, (String)"Visible", (Expression)this.visible);
    }

    public boolean isVisible(HttpServletRequest iRequest) {
        if (this.visible == null) {
            return true;
        }
        try {
            return (Boolean)this.visible.invoke(iRequest, Boolean.class);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void preRender(HttpServletRequest request) throws Exception {
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        boolean visible = this.isVisible(iRequest);
        if (!visible) {
            return;
        }
        String logged = ExpressionUtils.getMessage((Expression)this.loggedTitle, (HttpServletRequest)iRequest);
        String logout = ExpressionUtils.getMessage((Expression)this.logoutTitle, (HttpServletRequest)iRequest);
        PrintWriter iWriter = iResponse.getWriter();
        iWriter.print("<div class='");
        iWriter.print(this.cssClass);
        iWriter.print("'>");
        iWriter.println(HtmlUtils.encode2HTML((String)logged, (boolean)false));
        iWriter.print(HtmlUtils.encode2HTML((String)iRequest.getUserPrincipal().getName(), (boolean)false));
        iWriter.print(HtmlUtils.encode2HTML((String)" | ", (boolean)false));
        iWriter.println("<a href='" + iRequest.getContextPath() + "/j_spring_security_logout' title='logout'>");
        iWriter.println(HtmlUtils.encode2HTML((String)logout, (boolean)false));
        iWriter.println("</a>");
        iWriter.println("</div>");
    }
}

