/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.bricks;

import java.io.PrintWriter;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.util.HtmlUtils;
import org.ow2.opensuit.core.util.ReflectionHelper;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.xml.base.html.form.FormRenderingContext;
import org.ow2.opensuit.xml.base.html.form.FormSubmitContext;
import org.ow2.opensuit.xml.base.html.form.field.BaseSingleValueField;
import org.ow2.opensuit.xmlmap.annotations.XmlDoc;
import org.ow2.opensuit.xmlmap.annotations.XmlElement;
import org.ow2.opensuit.xmlmap.interfaces.IInitializable;
import org.ow2.opensuit.xmlmap.interfaces.IInitializationSupport;
import org.ow2.opensuit.xmlmap.interfaces.IInstantiationContext;

@XmlDoc(value="A rating editor form field.<br/>Supported value types are: any number type or class.")
@XmlElement
public class RatingField
extends BaseSingleValueField
implements IInitializable {
    private Class<?> bindingType;

    public void initialize(IInitializationSupport initSupport, IInstantiationContext instContext) {
        super.initialize(initSupport, instContext);
        if (initSupport.initialize((Object)this.bind)) {
            this.bindingType = this.bind.getType();
            if (!this.bind.isConvertible(Integer.class)) {
                initSupport.addValidationMessage((Object)this, "Bind", 1, "Expression " + this.bind + " has invalid type (" + this.bind.getType() + "): int, Integer or BigInteger expected.");
            }
        }
    }

    public Type getValueGenericType() {
        return this.getValueType();
    }

    public Class<?> getValueType() {
        if (this.bindingType != null) {
            return this.bindingType;
        }
        return Integer.class;
    }

    protected Object getValueFromRequest(HttpServletRequest iRequest, FormSubmitContext submitContext) throws ValidationError {
        String val = submitContext.getSubmitValue(this.getFieldName());
        try {
            return ReflectionHelper.parse2Type((String)val, (Class)this.bind.getType());
        }
        catch (NumberFormatException e) {
            throw new LocalizedValidationError("validation.int.not_an_int", "opensuit");
        }
        catch (ReflectionHelper.NumberOutOfBoundsException e) {
            throw new LocalizedValidationError("validation.int.out_of_bounds", "opensuit", new Object[]{e.getMin(), e.getMax()});
        }
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
    }

    protected void renderInput(HttpServletRequest iRequest, HttpServletResponse iResponse, FormRenderingContext iContext) throws Exception {
        PrintWriter iWriter = iResponse.getWriter();
        boolean editable = iContext.isEditable() && this.isEditable(iRequest);
        boolean editMode = iContext.isEditMode();
        String val = null;
        val = editable && iContext.getSubmitContext() != null && iContext.getSubmitContext().isSubmitAction() ? iContext.getSubmitContext().getSubmitValue(this.getFieldName()) : String.valueOf(this.bind.invoke(iRequest));
        if (val == null) {
            val = "";
        }
        int nbPixels = 17 * Integer.parseInt(val);
        if (editMode) {
            HtmlUtils.includeJavaScript((HttpServletRequest)iRequest, (HttpServletResponse)iResponse, (String)"org/ow2/dragon/ui/js/Rating.js");
            String id = this.bind.getID();
            iWriter.println("<div id=\"star\">");
            iWriter.println("<ul id=\"star0\" class=\"star\" onclick=\"star.update(event,this, 'main_" + id + "');\" onmousemove=\"star.mouse(event,this)\" \">");
            iWriter.println("<li id=\"starCur0\" class=\"curr\" title=\"" + val + "\" style=\"width: " + nbPixels + "px;\"></li>");
            iWriter.println("</ul>");
            if (nbPixels > 0) {
                iWriter.println("<div id=\"starUser0\" class=\"user\">" + val + "/5</div>");
            } else {
                iWriter.println("<div id=\"starUser0\" class=\"user\">Rate it!</div>");
            }
            iWriter.println("<input id=\"main_" + id + "\" type=\"hidden\" value=\"" + val + "\" name=\"" + id + "\"/>");
            iWriter.println("</div>");
        } else {
            iWriter.println("<div id=\"star\">");
            iWriter.println("<ul id=\"star0\" class=\"star\">");
            iWriter.println("<li id=\"starCur0\" class=\"curr\" title=\"" + val + "\" style=\"width: " + nbPixels + "px;\"></li>");
            iWriter.println("</ul>");
            if (nbPixels > 0) {
                iWriter.println("<div id=\"starUser0\" class=\"user\">" + val + "/5</div>");
            } else {
                iWriter.println("<div id=\"starUser0\" class=\"user\">Rate it!</div>");
            }
            iWriter.println("</div>");
        }
    }
}

