/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.businessdelegate.factory;

import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.ow2.dragon.api.service.administration.RoleGroupManager;
import org.ow2.dragon.api.service.administration.UserManager;
import org.ow2.dragon.api.service.common.TModelManager;
import org.ow2.dragon.api.service.dataloader.DataLoader;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.lifecycle.LifecycleManager;
import org.ow2.dragon.api.service.lifecycle.LifecycleServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.service.organization.PartyManager;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.service.technology.TechnologyManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.ui.businessdelegate.DragonDelegateException;
import org.ow2.dragon.ui.businessdelegate.factory.DragonServiceManager;
import org.ow2.opensuit.core.session.OpenSuitSession;
import org.uddi.api_v3_porttype.UDDIPublicationPortType;

public class DragonServiceFactory {
    private Logger logger = Logger.getLogger(this.getClass());
    private static DragonServiceFactory instance;
    private DragonServiceManager dragonServiceManager;

    public static DragonServiceFactory getInstance() throws DragonDelegateException {
        if (instance == null) {
            instance = new DragonServiceFactory();
        }
        return instance;
    }

    public static DragonServiceFactory getInstance(ServletContext context) throws DragonDelegateException {
        if (instance == null) {
            instance = new DragonServiceFactory(context);
        }
        return instance;
    }

    private DragonServiceFactory() throws DragonDelegateException {
        ServletContext servletContext = OpenSuitSession.getCurrentRequest().getSession().getServletContext();
        this.createDragonServiceManager(servletContext);
    }

    private DragonServiceFactory(ServletContext servletContext) throws DragonDelegateException {
        this.createDragonServiceManager(servletContext);
    }

    private void createDragonServiceManager(ServletContext servletContext) throws DragonDelegateException {
        String smClazzName;
        this.logger.debug((Object)"Create the DragonServiceManager");
        if (servletContext != null && (smClazzName = servletContext.getInitParameter("service-manager")) != null && !smClazzName.equals("")) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> serviceManagerClazz = cl.loadClass(smClazzName);
                this.dragonServiceManager = (DragonServiceManager)serviceManagerClazz.newInstance();
                this.dragonServiceManager.init(servletContext);
            }
            catch (ClassNotFoundException e) {
                throw new DragonDelegateException("Can't load service manager class: " + smClazzName);
            }
            catch (InstantiationException e) {
                throw new DragonDelegateException("Given class is not an instanciable class: " + smClazzName);
            }
            catch (IllegalAccessException e) {
                throw new DragonDelegateException("Can't load service manager class: " + smClazzName);
            }
        }
    }

    public OrganizationManager getOrganizationManager() {
        return this.dragonServiceManager.getOrganizationManager();
    }

    public PostManager getPostManager() {
        return this.dragonServiceManager.getPostManager();
    }

    public PersonManager getPersonManager() {
        return this.dragonServiceManager.getPersonManager();
    }

    public PartyManager getPartyManager() {
        return this.dragonServiceManager.getPartyManager();
    }

    public RoleOfPartyManager getRoleOfPartyManager() {
        return this.dragonServiceManager.getRoleOfPartyManager();
    }

    public TechServiceManager getTechServiceManager() {
        return this.dragonServiceManager.getTechServiceManager();
    }

    public EndpointManager getEndpointManager() {
        return this.dragonServiceManager.getEndpointManager();
    }

    public WSDLManager getWSDLImporter() {
        return this.dragonServiceManager.getWSDLImporter();
    }

    public TechnologyManager getTechnologyManager() {
        return this.dragonServiceManager.getTechnologyManager();
    }

    public DataLoader getDataLoader() {
        return this.dragonServiceManager.getDataLoader();
    }

    public MetadataService getMetadataService() {
        return this.dragonServiceManager.getMetadataService();
    }

    public UDDIPublicationPortType getUDDIPublicationService() {
        return this.dragonServiceManager.getUDDIPublicationService();
    }

    public TModelManager getTModelManager() {
        return this.dragonServiceManager.getTModelManager();
    }

    public RoleGroupManager getRoleGroupManager() {
        return this.dragonServiceManager.getRoleGroupManager();
    }

    public UserManager getUserManager() {
        return this.dragonServiceManager.getUserManager();
    }

    public LifecycleManager getLifecycleManager() {
        return this.dragonServiceManager.getLifecycleManager();
    }

    public LifecycleServiceManager getLifecycleServiceManager() {
        return this.dragonServiceManager.getLifecycleServiceManager();
    }
}

