/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.ui.businessdelegate.spring.deployment;

import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

public class EndpointManagerImpl
implements EndpointManager {
    private final EndpointManager endpointManager;

    public EndpointManagerImpl(ApplicationContext context) {
        this.endpointManager = (EndpointManager)context.getBean("endpointManager");
    }

    public List<EndpointTO> getAllEndpoints(RequestOptionsTO requestOptionsTO) throws DeploymentException {
        return this.endpointManager.getAllEndpoints(requestOptionsTO);
    }

    public EndpointTO getEndpoint(String endpointId, String user) throws DeploymentException {
        return this.endpointManager.getEndpoint(endpointId, user);
    }

    public List<EndpointTO> getEndpointsByBinding(String bindingId, RequestOptionsTO requestOptionsTO) throws DeploymentException {
        return this.endpointManager.getEndpointsByBinding(bindingId, requestOptionsTO);
    }

    public List<EndpointTO> getEndpointsByTechService(String techServiceId, RequestOptionsTO requestOptionsTO) {
        return this.endpointManager.getEndpointsByTechService(techServiceId, requestOptionsTO);
    }

    public void removeEndpoint(String endpointId) throws DeploymentException {
        this.endpointManager.removeEndpoint(endpointId);
    }

    public String updateEndpoint(EndpointTO endpointTO) throws DeploymentException {
        return this.endpointManager.updateEndpoint(endpointTO);
    }

    public List<EndpointTO> getEndpointsByTag(String tag) {
        return this.endpointManager.getEndpointsByTag(tag);
    }

    public void removeTag(String tag, String endpointId) {
        this.endpointManager.removeTag(tag, endpointId);
    }

    public void updateComments(String endpointId, CommentTO commentTO) {
        this.endpointManager.updateComments(endpointId, commentTO);
    }

    public float updateGlobalRating(String endpointId) {
        return this.endpointManager.updateGlobalRating(endpointId);
    }

    public void removeComment(String endpointId, String commentId) {
        this.endpointManager.removeComment(endpointId, commentId);
    }

    public List<KeyedRefTO> getCategoriesForEndpoint(String endpointId) throws DeploymentException {
        return this.endpointManager.getCategoriesForEndpoint(endpointId);
    }

    public void removeCategories(String techServiceId, List<String> categoryIds) throws DeploymentException {
        this.endpointManager.removeCategories(techServiceId, categoryIds);
    }

    public void addCategory(String endpointId, String categoryId, String categoryValueId) throws DeploymentException {
        this.endpointManager.addCategory(endpointId, categoryId, categoryValueId);
    }

    public void addCategory(String endpointId, String categoryId, String categoryValue, String categoryDesc) throws DeploymentException {
        this.endpointManager.addCategory(endpointId, categoryId, categoryValue, categoryDesc);
    }

    public String createEndpoint(String epName, String epAddress, String servId) throws DeploymentException {
        return this.endpointManager.createEndpoint(epName, epAddress, servId);
    }

    public String addServiceDefFile(Document wsdlDoc, String wsdlFileName, String endpointId, boolean storeEntities) throws DeploymentException, TimeoutException {
        return this.endpointManager.addServiceDefFile(wsdlDoc, wsdlFileName, endpointId, storeEntities);
    }

    public String addServiceDefFile(URI wsdlURI, String wsdlFileName, String endpointId, boolean storeEntities) throws DeploymentException, TimeoutException {
        return this.endpointManager.addServiceDefFile(wsdlURI, wsdlFileName, endpointId, storeEntities);
    }

    public void removeServiceSpec(String endpointId, String serviceSpecificationId) throws DeploymentException {
        this.endpointManager.removeServiceSpec(endpointId, serviceSpecificationId);
    }
}

